/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractDateFunction;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;

public class EndOfDayFunction
extends AbstractDateFunction {
    public static final String FUNCTION_END_OF_DAY = "endOfDay";

    EndOfDayFunction(Clock clock, TimeZoneManager timeZoneManager) {
        super(clock, timeZoneManager);
    }

    public EndOfDayFunction(TimeZoneManager timeZoneManager) {
        super(timeZoneManager);
    }

    @Override
    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        boolean hasAdjustment = operand.getArgs().size() == 1;
        int unit = 0;
        int incrementValue = 0;
        if (hasAdjustment) {
            String duration = operand.getArgs().get(0);
            unit = this.getDurationUnit(duration);
            if (unit == -1) {
                unit = 5;
            }
            incrementValue = this.getDurationAmount(duration);
        }
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(this.timeZoneManager.getLoggedInUserTimeZone());
        cal.setTime(this.clock.getCurrentDate());
        cal.getTime();
        if (hasAdjustment && (unit == 1 || unit == 2)) {
            ((Calendar)cal).add(unit, incrementValue);
        }
        cal.set(11, ((Calendar)cal).getActualMaximum(11));
        cal.set(12, ((Calendar)cal).getActualMaximum(12));
        cal.set(13, ((Calendar)cal).getActualMaximum(13));
        cal.set(14, ((Calendar)cal).getActualMaximum(14));
        if (hasAdjustment && unit != 1 && unit != 2) {
            ((Calendar)cal).add(unit, incrementValue);
        }
        return Collections.singletonList(new QueryLiteral((Operand)operand, cal.getTimeInMillis()));
    }
}

