/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.plugin.jql.function.JqlFunction;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.List;

public class EchoFunction
extends AbstractJqlFunction
implements JqlFunction {
    public static final String ECHO_FUNCTION = "echo";
    public static final String EMPTY_FLAG = "none";
    public static final String EMPTY_ESCAPED = "\"none\"";

    @Override
    public MessageSet validate(User searcher, FunctionOperand operand, TerminalClause terminalClause) {
        return new MessageSetImpl();
    }

    @Override
    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        ArrayList<QueryLiteral> literals = new ArrayList<QueryLiteral>(operand.getArgs().size());
        for (String argument : operand.getArgs()) {
            if (argument.equals(EMPTY_FLAG)) {
                literals.add(new QueryLiteral(operand));
                continue;
            }
            literals.add(new QueryLiteral((Operand)operand, this.cleanArg(argument)));
        }
        return literals;
    }

    @Override
    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    @Override
    public JiraDataType getDataType() {
        return JiraDataTypes.ALL;
    }

    private String cleanArg(String arg) {
        if (arg.equals(EMPTY_ESCAPED)) {
            return EMPTY_FLAG;
        }
        return arg;
    }
}

