/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractIssueTypeFunction;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AllStandardIssueTypesFunction
extends AbstractIssueTypeFunction {
    public static final String FUNCTION_STANDARD_ISSUE_TYPES = "standardIssueTypes";
    private final ConstantsManager constantsManager;

    public AllStandardIssueTypesFunction(ConstantsManager constantsManager, SubTaskManager subTaskManager) {
        super(subTaskManager);
        this.constantsManager = Assertions.notNull("constantsManager", constantsManager);
    }

    @Override
    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        Collection<IssueType> issueTypes = this.constantsManager.getRegularIssueTypeObjects();
        ArrayList<QueryLiteral> literals = new ArrayList<QueryLiteral>();
        for (IssueType subIssueType : issueTypes) {
            literals.add(new QueryLiteral((Operand)operand, subIssueType.getId()));
        }
        return literals;
    }
}

