/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.core.util.Clock;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.jql.validator.NumberOfArgumentsValidator;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.RealClock;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractDateFunction
extends AbstractJqlFunction {
    protected final Clock clock;
    protected final TimeZoneManager timeZoneManager;
    private static final int MIN_EXPECTED_ARGS = 0;
    private static final int MAX_EXPECTED_ARGS = 1;
    private static final Pattern DURATION_PATTERN = Pattern.compile("([-\\+]?)(\\d+)([mhdwMy]?)");

    AbstractDateFunction(TimeZoneManager timeZoneManager) {
        this(RealClock.getInstance(), timeZoneManager);
    }

    AbstractDateFunction(Clock clock, TimeZoneManager timeZoneManager) {
        this.clock = clock;
        this.timeZoneManager = timeZoneManager;
    }

    @Override
    public MessageSet validate(User searcher, FunctionOperand operand, TerminalClause terminalClause) {
        String duration;
        I18nHelper i18n = this.getI18n();
        MessageSet messageSet = new NumberOfArgumentsValidator(0, 1, i18n).validate(operand);
        if (operand.getArgs().size() == 1 && !DURATION_PATTERN.matcher(duration = operand.getArgs().get(0)).matches()) {
            messageSet.addErrorMessage(i18n.getText("jira.jql.date.function.duration.incorrect", operand.getName()));
        }
        return messageSet;
    }

    protected int getDurationAmount(String duration) {
        Matcher matcher = DURATION_PATTERN.matcher(duration);
        try {
            if (matcher.matches() && matcher.groupCount() > 1) {
                if (matcher.group(1).equals("+")) {
                    return Integer.parseInt(matcher.group(2));
                }
                if (matcher.group(1).equals("-")) {
                    return -Integer.parseInt(matcher.group(2));
                }
            }
            return Integer.parseInt(matcher.group(2));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected int getDurationUnit(String duration) {
        Matcher matcher = DURATION_PATTERN.matcher(duration);
        if (matcher.matches() && matcher.groupCount() > 2) {
            String unitGroup = matcher.group(3);
            if (unitGroup.equalsIgnoreCase("y")) {
                return 1;
            }
            if (unitGroup.equals("M")) {
                return 2;
            }
            if (unitGroup.equalsIgnoreCase("w")) {
                return 4;
            }
            if (unitGroup.equalsIgnoreCase("d")) {
                return 5;
            }
            if (unitGroup.equalsIgnoreCase("h")) {
                return 11;
            }
            if (unitGroup.equals("m")) {
                return 12;
            }
        }
        return -1;
    }

    @Override
    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    @Override
    public JiraDataType getDataType() {
        return JiraDataTypes.DATE;
    }

    protected static enum UNIT {
        YEAR,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE;

    }
}

