/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class IssueTabPanelModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<IssueTabPanel>
implements IssueTabPanelModuleDescriptor {
    private static final Logger log = Logger.getLogger(IssueTabPanelModuleDescriptorImpl.class);
    String label;
    private String labelKey;
    boolean isDefault = false;
    private int order;
    private boolean isSortable = false;
    private boolean supportsAjaxLoad;

    public IssueTabPanelModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.label = element.element("label").getTextTrim();
        if (element.element("label").attribute("key") != null) {
            this.labelKey = element.element("label").attribute("key").getText();
        }
        this.isDefault = IssueTabPanelModuleDescriptorImpl.getBooleanElement(element, "default");
        this.order = ModuleDescriptorXMLUtils.getOrder(element);
        this.isSortable = IssueTabPanelModuleDescriptorImpl.getBooleanElement(element, "sortable");
        this.supportsAjaxLoad = IssueTabPanelModuleDescriptorImpl.getBooleanElement(element, "supports-ajax-load");
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(IssueTabPanel.class);
    }

    private static boolean getBooleanElement(Element parentElement, String elementName) {
        Element element = parentElement.element(elementName);
        if (element == null) {
            return false;
        }
        String isDefaultText = element.getTextTrim();
        return isDefaultText != null && Boolean.valueOf(isDefaultText) != false;
    }

    private IssueTabPanel getTabPanel() {
        return (IssueTabPanel)this.getModule();
    }

    @Override
    public String getLabel() {
        if (this.labelKey != null) {
            return this.getI18nBean().getText(this.labelKey);
        }
        return this.label;
    }

    @Override
    public List<IssueAction> getActions(Issue issue, User remoteUser) {
        IssueTabPanel tabPanel = this.getTabPanel();
        try {
            if (tabPanel.showPanel(issue, remoteUser)) {
                return this.getTabPanel().getActions(issue, remoteUser);
            }
            return Collections.emptyList();
        }
        catch (AbstractMethodError ex) {
            log.error((Object)("AbstractMethodError detected for IssueTabPanel '" + this.getName() + "'. This likely means the plugin is not compatible with this version of JIRA."));
            GenericMessageAction action = new GenericMessageAction(this.getI18nBean().getText("viewissue.pluginerror"));
            return Collections.singletonList(action);
        }
        catch (RuntimeException ex) {
            log.error((Object)("Error occured in IssueTabPanel '" + this.getName() + "'."), (Throwable)ex);
            GenericMessageAction action = new GenericMessageAction(this.getI18nBean().getText("viewissue.pluginerror"));
            return Collections.singletonList(action);
        }
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public boolean isSortable() {
        return this.isSortable;
    }

    @Override
    public boolean isSupportsAjaxLoad() {
        return this.supportsAjaxLoad;
    }
}

