/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.customfield;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.BulkMoveHelper;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import webwork.action.Action;

public class CustomFieldTypeModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<CustomFieldType>
implements CustomFieldTypeModuleDescriptor {
    private RendererManager rendererManager;

    public CustomFieldTypeModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, RendererManager rendererManager, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
        this.rendererManager = rendererManager;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(CustomFieldType.class);
    }

    @Override
    public boolean isViewTemplateExists() {
        return this.isResourceExist("view");
    }

    @Override
    public boolean isColumnViewTemplateExists() {
        return this.isResourceExist("column-view");
    }

    @Override
    public boolean isEditTemplateExists() {
        return this.isResourceExist("edit");
    }

    @Override
    public boolean isXMLTemplateExists() {
        return this.isResourceExist("xml");
    }

    @Override
    public String getEditHtml(FieldConfig config, Map customFieldValuesHolder, Issue issue, Action action, Map displayParameters, FieldLayoutItem fieldLayoutItem) {
        Assertions.notNull("config", config);
        Map<String, Object> params = CustomFieldUtils.buildParams(config.getCustomField(), config, issue, fieldLayoutItem, null, customFieldValuesHolder, action, displayParameters);
        return this.getHtml("edit", params);
    }

    @Override
    public String getBulkMoveHtml(FieldConfig config, Map customFieldValuesHolder, Issue issue, Action action, Map displayParameters, FieldLayoutItem fieldLayoutItem, Map<Long, BulkMoveHelper.DistinctValueResult> distinctValues, BulkMoveHelper bulkMoveHelper) {
        Assertions.notNull("config", config);
        Map<String, Object> params = CustomFieldUtils.buildParams(config.getCustomField(), config, issue, fieldLayoutItem, null, customFieldValuesHolder, action, displayParameters);
        params.put("valuesToMap", distinctValues);
        params.put("bulkMoveHelper", bulkMoveHelper);
        String html = this.getResourceDescriptor("velocity", "bulk-move") != null ? this.getHtml("bulk-move", params) : this.getHtml("edit", params);
        return html;
    }

    @Override
    public String getEditDefaultHtml(FieldConfig config, Map customFieldValuesHolder, Issue issue, Action action, Map displayParameters, FieldLayoutItem fieldLayoutItem) {
        Assertions.notNull("config", config);
        Map<String, Object> params = CustomFieldUtils.buildParams(config.getCustomField(), config, issue, fieldLayoutItem, null, customFieldValuesHolder, action, displayParameters);
        String html = this.getResourceDescriptor("velocity", "edit-default") != null ? this.getHtml("edit-default", params) : this.getHtml("edit", params);
        return html;
    }

    @Override
    public String getColumnViewHtml(CustomField field, Object value, Issue issue, Map displayParams, FieldLayoutItem fieldLayoutItem) {
        if (this.isResourceExist("column-view")) {
            return this.getViewHtmlByValue(fieldLayoutItem, value, field, issue, "column-view", displayParams);
        }
        return this.getViewHtmlByValue(fieldLayoutItem, value, field, issue, "view", displayParams);
    }

    @Override
    public String getViewHtml(CustomField field, Object value, Issue issue, FieldLayoutItem fieldLayoutItem) {
        return this.getViewHtml(field, value, issue, fieldLayoutItem, null);
    }

    @Override
    public String getViewHtml(CustomField field, Object value, Issue issue, FieldLayoutItem fieldLayoutItem, Map displayParameters) {
        return this.getViewHtmlByValue(fieldLayoutItem, value, field, issue, "view", displayParameters);
    }

    @Override
    public String getViewXML(CustomField field, Issue issue, FieldLayoutItem fieldLayoutItem, boolean raw) {
        Map<String, Object> combinedMap = this.getCombinedMap(field.getCustomFieldType().getVelocityParameters(issue, field, fieldLayoutItem), MapBuilder.build("value", field.getValue(issue)));
        if (field.isRenderable() && !raw) {
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            combinedMap.put("renderedValue", this.rendererManager.getRenderedContent(rendererType, (String)field.getValue(issue), issue.getIssueRenderContext()));
        }
        return this.getHtml("xml", combinedMap);
    }

    @Override
    public String getDefaultViewHtml(FieldConfig fieldConfig, FieldLayoutItem fieldLayoutItem) {
        Object value = fieldConfig.getCustomField().getCustomFieldType().getDefaultValue(fieldConfig);
        return this.getViewHtmlByValue(fieldLayoutItem, value, fieldConfig.getCustomField(), null, "view", null);
    }

    private String getViewHtmlByValue(FieldLayoutItem fieldLayoutItem, Object value, CustomField field, Issue issue, String templateNameView, Map displayParams) {
        Map<String, Object> params = CustomFieldUtils.buildParams(field, null, issue, fieldLayoutItem, value, null, null, displayParams);
        return this.getHtml(templateNameView, params);
    }

    private Map<String, Object> getCombinedMap(Map<String, Object> map1, Map<String, Object> map2) {
        HashMap<String, Object> allParams = new HashMap<String, Object>();
        if (map1 != null) {
            allParams.putAll(map1);
        }
        if (map2 != null) {
            allParams.putAll(map2);
        }
        return allParams;
    }
}

