/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.componentpanel.impl;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.plugin.componentpanel.BrowseComponentContext;
import com.atlassian.jira.plugin.componentpanel.impl.GenericTabPanel;
import com.atlassian.jira.plugin.util.TabPanelUtil;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

public class PopularIssuesTabPanel
extends GenericTabPanel {
    private final SearchProvider searchProvider;
    private final ConstantsManager constantsManager;
    private final ApplicationProperties applicationProperties;
    private final FieldVisibilityManager fieldVisibilityManager;

    public PopularIssuesTabPanel(ProjectManager projectManager, JiraAuthenticationContext authenticationContext, SearchProvider searchProvider, ConstantsManager constantsManager, ApplicationProperties applicationProperties, FieldVisibilityManager fieldVisibilityManager) {
        super(projectManager, authenticationContext, fieldVisibilityManager);
        this.searchProvider = searchProvider;
        this.constantsManager = constantsManager;
        this.applicationProperties = applicationProperties;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseComponentContext context) {
        this.setResolved();
        TabPanelUtil.PopularIssues popularIssues = new TabPanelUtil.PopularIssues(this.searchProvider, this.constantsManager);
        Map<String, Object> params = super.createVelocityParams(context);
        params.put("popularIssues", popularIssues.getIssues(context, this.isResolved()));
        params.put("resolved", this.isResolved());
        params.put("fieldVisibility", this.fieldVisibilityManager);
        return params;
    }

    private void setResolved() {
        String resolvedParam = this.getResolvedParam();
        if (StringUtils.isNotEmpty((String)resolvedParam)) {
            ActionContext.getSession().put("jira.component.browser.popular.issues.resolved", Boolean.valueOf(resolvedParam));
        }
    }

    private boolean isResolved() {
        String requestParameter;
        Boolean resolved = (Boolean)ActionContext.getSession().get("jira.component.browser.popular.issues.resolved");
        if (resolved == null && StringUtils.isNotEmpty((String)(requestParameter = this.getResolvedParam()))) {
            resolved = Boolean.valueOf(requestParameter);
            ActionContext.getSession().put("jira.component.browser.popular.issues.resolved", resolved);
        }
        return resolved != null && resolved != false;
    }

    private String getResolvedParam() {
        DefaultVelocityRequestContextFactory vf = new DefaultVelocityRequestContextFactory(this.applicationProperties);
        VelocityRequestContext context = vf.getJiraVelocityRequestContext();
        return context.getRequestParameter("resolved");
    }

    @Override
    public boolean showPanel(BrowseComponentContext context) {
        return super.showPanel(context) && this.applicationProperties.getOption("jira.option.voting");
    }
}

