/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.browsepanel;

import com.atlassian.jira.plugin.TabPanelModuleDescriptor;
import com.atlassian.jira.plugin.browsepanel.TabPanel;
import com.atlassian.jira.plugin.projectpanel.fragment.MenuFragment;
import com.atlassian.jira.plugin.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.project.browse.BrowseContext;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractFragmentBasedTabPanel<D extends TabPanelModuleDescriptor, C extends BrowseContext, F extends ProjectTabPanelFragment>
implements TabPanel<D, C> {
    protected D moduleDescriptor;

    @Override
    public void init(D descriptor) {
        this.moduleDescriptor = descriptor;
    }

    @Override
    public String getHtml(C ctx) {
        StringBuilder sb = new StringBuilder();
        List<MenuFragment> menuFrags = this.getMenuFragments();
        String inlineHeader = this.getInlineHeader();
        if (!menuFrags.isEmpty()) {
            sb.append("<div id=\"quicklinks\">\n");
            sb.append("<ul class=\"operations\">\n");
            for (MenuFragment menuFragment : menuFrags) {
                if (!menuFragment.showFragment((BrowseContext)ctx)) continue;
                sb.append("<li class=\"aui-dd-parent\">\n");
                sb.append(menuFragment.getHtml((BrowseContext)ctx));
                sb.append("</li>\n");
            }
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)inlineHeader)) {
            sb.append("<h2>" + inlineHeader + "</h2>");
        }
        this.createContent(ctx, sb);
        return sb.toString();
    }

    public String getInlineHeader() {
        return null;
    }

    private void createContent(C ctx, StringBuilder sb) {
        StringBuilder leftcolSb = new StringBuilder();
        boolean hasLeftContent = this.createColumnContent(ctx, leftcolSb, this.getLeftColumnFragments(ctx));
        StringBuilder rightcolSb = new StringBuilder();
        boolean hasRightContent = this.createColumnContent(ctx, rightcolSb, this.getRightColumnFragments(ctx));
        if (hasLeftContent && hasRightContent) {
            sb.append("<div class=\"aui-group\">");
            sb.append("<div class=\"aui-item\">");
            sb.append((CharSequence)leftcolSb);
            sb.append("</div>");
            sb.append("<div class=\"aui-item\">");
            sb.append((CharSequence)rightcolSb);
            sb.append("</div>");
            sb.append("</div>");
        } else if (!hasLeftContent && !hasRightContent) {
            sb.append(this.createEmptyContent());
        } else {
            sb.append((CharSequence)leftcolSb);
            sb.append((CharSequence)rightcolSb);
        }
    }

    public String createEmptyContent() {
        return this.moduleDescriptor.getI18nBean().getText("browseproject.empty.tab.generic");
    }

    private boolean createColumnContent(C ctx, StringBuilder sb, List<F> columnFragments) {
        boolean hasAtleastOneFrag = false;
        for (ProjectTabPanelFragment fragment : columnFragments) {
            hasAtleastOneFrag = this.appendFragmentIfVisible(ctx, sb, fragment) || hasAtleastOneFrag;
        }
        return hasAtleastOneFrag;
    }

    private boolean appendFragmentIfVisible(C ctx, StringBuilder sb, F fragment) {
        if (fragment.showFragment((BrowseContext)ctx)) {
            sb.append("<div class=\"module\" id=\"frag").append(fragment.getId()).append("\">");
            sb.append(fragment.getHtml((BrowseContext)ctx));
            sb.append("</div>");
            return true;
        }
        return false;
    }

    protected abstract List<F> getLeftColumnFragments(C var1);

    protected abstract List<F> getRightColumnFragments(C var1);

    protected List<MenuFragment> getMenuFragments() {
        return Collections.emptyList();
    }

    @Override
    public boolean showPanel(C context) {
        return !this.getLeftColumnFragments(context).isEmpty() || !this.getRightColumnFragments(context).isEmpty();
    }
}

