/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.startup.SystemTenantJiraHomeLocator;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.container.impl.DefaultOsgiPersistentCache;
import java.io.File;
import org.apache.log4j.Logger;

public interface PluginPath {
    public static final String PLUGINS_DIRECTORY = "plugins";
    public static final String INSTALLED_PLUGINS_SUBDIR = PathUtils.joinPaths("plugins", "installed-plugins");
    public static final String OSGI_SUBDIR = PathUtils.joinPaths("plugins", ".osgi-plugins");
    public static final String BUNDLED_SUBDIR = PathUtils.joinPaths("plugins", ".bundled-plugins");

    public boolean isConfigured();

    public File getPluginsDirectory();

    public File getInstalledPluginsDirectory();

    public File getBundledPluginsDirectory();

    public OsgiPersistentCache getOsgiPersistentCache();

    public static class JiraHomeAdapter
    implements PluginPath {
        private final JiraHome jiraHome = new SystemTenantJiraHomeLocator.SystemJiraHome();
        private final File pluginsDirectory = this.createDirectoryIfNecessary(this.jiraHome.getHome(), "plugins");
        private final File installedDirectory = this.createDirectoryIfNecessary(this.jiraHome.getHome(), INSTALLED_PLUGINS_SUBDIR);
        private final File bundledPluginsDirectory = this.createDirectoryIfNecessary(this.jiraHome.getHome(), BUNDLED_SUBDIR);
        private final OsgiPersistentCache osgiPersistentCache;
        private static final Logger log = Logger.getLogger(JiraHomeAdapter.class);

        public JiraHomeAdapter() {
            try {
                File osgiDirectory = this.createDirectoryIfNecessary(this.jiraHome.getHome(), OSGI_SUBDIR);
                this.osgiPersistentCache = new DefaultOsgiPersistentCache(osgiDirectory);
            }
            catch (OsgiContainerException ex) {
                String message;
                Throwable cause = ex.getCause();
                if (cause != null && (message = cause.getMessage()) != null && message.startsWith("Unable to delete file: ")) {
                    File file = new File(message.substring("Unable to delete file: ".length()));
                    log.error((Object)(message + "  exists:" + file.exists() + "  canRead:" + file.canRead() + "  canWrite:" + file.canWrite() + "  isDirectory:" + file.isDirectory()));
                }
                throw ex;
            }
        }

        @Override
        public boolean isConfigured() {
            try {
                this.jiraHome.getHomePath();
                return true;
            }
            catch (IllegalStateException e) {
                return false;
            }
        }

        @Override
        public File getPluginsDirectory() {
            return this.pluginsDirectory;
        }

        @Override
        public File getInstalledPluginsDirectory() {
            return this.installedDirectory;
        }

        @Override
        public File getBundledPluginsDirectory() {
            return this.bundledPluginsDirectory;
        }

        @Override
        public OsgiPersistentCache getOsgiPersistentCache() {
            return this.osgiPersistentCache;
        }

        private File createDirectoryIfNecessary(File root, String path) {
            File dir = new File(root, path);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IllegalStateException("Unable to create directory '" + dir + "'");
            }
            if (!dir.isDirectory()) {
                throw new IllegalStateException("File exists but is not a directory '" + dir + "'");
            }
            return dir;
        }
    }
}

