/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.system.VersionNumber;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPackageScannerConfiguration
implements PackageScannerConfiguration,
Startable {
    private final List<String> packageIncludes = CollectionBuilder.newBuilder("com.atlassian.*", "com.google.common.*", "javax.*", "net.jcip.*", "org.jfree.*", "org.joda.*", "org.quartz", "org.quartz.*", "com.opensymphony.*", "org.apache.*", "org.ofbiz.*", "org.xml.*", "org.w3c.*", "webwork.*", "org.tuckey.web.filters.urlrewrite.*", "org.bouncycastle*", "org.dom4j*", "org.jdom*", "com.perforce*", "org.slf4j*", "org.codehaus.jackson*").asList();
    private final List<String> packageExcludes = CollectionBuilder.newBuilder("com.atlassian.greenhopper", "com.springframework*", "org.springframework*", "com.sun.jersey.*", "javax.ws.*", "org.apache.tomcat.*", "org.apache.catalina.*", "org.apache.commons.logging*", "org.apache.jasper.*", "org.apache.coyote.*", "org.apache.naming*", "*..svn*").asList();
    private final List<String> jarIncludes = CollectionBuilder.newBuilder("*.jar").asList();
    private final List<String> jarExcludes = Collections.emptyList();
    private final Logger logger = LoggerFactory.getLogger(DefaultPackageScannerConfiguration.class);
    private final String hostVersion;
    private final Map<String, String> packageVersions;
    private static final String BLANK_OSGI_VERSION = "";

    public DefaultPackageScannerConfiguration(BuildUtilsInfo buildUtilsInfo) {
        this.hostVersion = buildUtilsInfo.getVersion();
        String jiraOsgiVersion = DefaultPackageScannerConfiguration.getAsOSGIVersion(this.hostVersion);
        this.packageVersions = MapBuilder.newBuilder().add("com.atlassian.jira*", jiraOsgiVersion).add("com.atlassian.configurable*", jiraOsgiVersion).add("com.atlassian.diff*", jiraOsgiVersion).add("com.atlassian.query*", jiraOsgiVersion).add("com.atlassian.velocity*", jiraOsgiVersion).add("com.opensymphony*", jiraOsgiVersion).add("org.apache.commons.dbcp*", "1.4.0").add("com.atlassian.crowd*", jiraOsgiVersion).add("com.atlassian.core*", jiraOsgiVersion).add("com.atlassian.seraph*", jiraOsgiVersion).add("javax.xml*", BLANK_OSGI_VERSION).add("org.xml*", BLANK_OSGI_VERSION).add("org.w3c*", BLANK_OSGI_VERSION).add("org.apache.commons.logging*", "1.1.1").add("com.atlassian.sal.api.*", buildUtilsInfo.getSalVersion()).add("com.atlassian.soy.renderer", DefaultPackageScannerConfiguration.getAsOSGIVersion(buildUtilsInfo.getBuildProperty("soy.templates.version"))).add("com.google.common.*", buildUtilsInfo.getGuavaOsgiVersion()).toMap();
    }

    private static String getAsOSGIVersion(String version) {
        return new VersionNumber(version).getOSGIVersion();
    }

    @Override
    public void start() throws Exception {
        this.logger.debug("Created package scanner configuration: {}", (Object)this);
    }

    public List<String> getJarIncludes() {
        return this.jarIncludes;
    }

    public List<String> getJarExcludes() {
        return this.jarExcludes;
    }

    public List<String> getPackageIncludes() {
        return this.packageIncludes;
    }

    public List<String> getPackageExcludes() {
        return this.packageExcludes;
    }

    public Map<String, String> getPackageVersions() {
        return this.packageVersions;
    }

    public String getCurrentHostVersion() {
        return this.hostVersion;
    }

    public ServletContext getServletContext() {
        return ServletContextProvider.getServletContext();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

