/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.configurable.ObjectConfigurationFactory;
import com.atlassian.configurable.ObjectDescriptor;
import com.atlassian.configurable.StringObjectDescription;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.ConfigurableModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.Map;
import org.dom4j.Element;

public abstract class AbstractConfigurableModuleDescriptor<T>
extends AbstractJiraModuleDescriptor<T>
implements ConfigurableModuleDescriptor {
    private Element element;
    private ObjectDescriptor objectDescriptor;
    private String objectDescriptorClassName = null;

    public AbstractConfigurableModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.element = element;
        Element objDescEl = element.element("objectdescriptor");
        if (objDescEl != null) {
            if (objDescEl.attribute("class") != null) {
                this.objectDescriptorClassName = objDescEl.attributeValue("class");
            } else {
                this.objectDescriptor = new StringObjectDescription(objDescEl.attributeValue("key"));
            }
        }
    }

    @Override
    public void enabled() {
        if (this.objectDescriptorClassName != null) {
            try {
                this.objectDescriptor = (ObjectDescriptor)this.plugin.loadClass(this.objectDescriptorClassName, this.getClass()).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException("Error finding object descriptor class:" + this.objectDescriptorClassName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new PluginParseException("Error creating object of class:" + this.objectDescriptorClassName, (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new PluginParseException("Error creating object of class:" + this.objectDescriptorClassName, (Throwable)e);
            }
        }
        super.enabled();
    }

    @Override
    public void disabled() {
        super.disabled();
        if (this.objectDescriptorClassName != null) {
            this.objectDescriptor = null;
        }
    }

    protected ObjectDescriptor getObjectDescriptor() {
        if (this.objectDescriptor == null && this.objectDescriptorClassName != null) {
            throw new IllegalStateException("ObjectDescriptor class '" + this.objectDescriptorClassName + "' is not loaded. This means that the plugin was not enabled successfully.");
        }
        return this.objectDescriptor;
    }

    @Override
    public ObjectConfiguration getObjectConfiguration(Map params) throws ObjectConfigurationException {
        ObjectConfigurationFactory objectConfigurationFactory = ComponentManager.getComponent(ObjectConfigurationFactory.class);
        if (!objectConfigurationFactory.hasObjectConfiguration(this.getCompleteKey())) {
            objectConfigurationFactory.loadObjectConfigurationFromElement(this.element, this.getObjectDescriptor(), this.getCompleteKey(), this.getClassLoader());
        }
        return objectConfigurationFactory.getObjectConfiguration(this.getCompleteKey(), params);
    }
}

