/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.permission.DefaultWorkflowPermission;
import com.atlassian.jira.permission.DenyWorkflowPermission;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.WorkflowPermission;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.type.SecurityType;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class WorkflowPermissionFactory {
    public static final String PREFIX = "jira.permission.";
    public static final String PREFIX_PARENT = "jira.permission.subtasks.";
    private static final Logger log = Logger.getLogger(WorkflowPermissionFactory.class);
    private PermissionTypeManager permTypeManager;

    public WorkflowPermissionFactory(PermissionTypeManager permTypeManager) {
        this.permTypeManager = permTypeManager;
    }

    public List<WorkflowPermission> getWorkflowPermissions(PermissionContext ctx, int permissionId, boolean isParent) {
        StepDescriptor relevantStepDescriptor = ctx.getRelevantStepDescriptor();
        if (relevantStepDescriptor == null) {
            return Collections.emptyList();
        }
        Map metaAttributes = relevantStepDescriptor.getMetaAttributes();
        ArrayList<WorkflowPermission> perms = new ArrayList<WorkflowPermission>(metaAttributes.size());
        for (Map.Entry metaEntry : metaAttributes.entrySet()) {
            WorkflowPermission perm = this.createWorkflowPermission(permissionId, isParent, (String)metaEntry.getKey(), (String)metaEntry.getValue());
            if (perm == null) continue;
            perms.add(perm);
        }
        return perms;
    }

    public final WorkflowPermission createWorkflowPermission(int relevantPermission, boolean isParent, String metaKey, String metaValue) {
        String prefix;
        String relevantPermName = Permissions.getShortName(relevantPermission);
        String string = prefix = isParent ? PREFIX_PARENT : PREFIX;
        if (!metaKey.startsWith(prefix)) {
            return null;
        }
        try {
            StringTokenizer tok = new StringTokenizer(metaKey.substring(prefix.length()), ".", false);
            String permName = tok.nextToken();
            if (!relevantPermName.equals(permName)) {
                return null;
            }
            int permission = Permissions.getType(permName);
            String grantTypeName = tok.nextToken();
            if ("denied".equals(grantTypeName)) {
                return new DenyWorkflowPermission(permission);
            }
            Map permTypes = this.permTypeManager.getTypes();
            SecurityType grantType = (SecurityType)permTypes.get(grantTypeName);
            if (grantType == null) {
                throw new RuntimeException("Unknown type '" + grantTypeName + "' in meta attribute '" + metaKey + "'. Valid permission types are defined in permission-types.xml");
            }
            return new DefaultWorkflowPermission(permission, grantType, metaValue, isParent);
        }
        catch (NoSuchElementException e) {
            String errMsg = "Error parsing meta attribute <meta name='" + metaKey + "'>" + metaValue + "</meta>. Name format is 'jira.permission.[subtasks].<permission>.[group|user|assignee|...]'";
            log.error((Object)errMsg);
            throw new RuntimeException(errMsg);
        }
    }
}

