/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.WorkflowIssueOperation;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionContextImpl;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class DefaultPermissionContextFactory
implements PermissionContextFactory {
    private static final Logger log = Logger.getLogger(DefaultPermissionContextFactory.class);
    private final WorkflowManager workflowManager;

    public DefaultPermissionContextFactory(WorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    @Override
    public PermissionContext getPermissionContext(Issue issue) {
        return new PermissionContextImpl(issue, issue.getProjectObject(), issue.getStatusObject());
    }

    @Override
    public PermissionContext getPermissionContext(Project project) {
        return new PermissionContextImpl(null, project, null);
    }

    public PermissionContext getPermissionContext(Issue issue, Status issueStatus) {
        return new PermissionContextImpl(issue, issue.getProjectObject(), issueStatus);
    }

    @Override
    public PermissionContext getPermissionContext(GenericValue projectOrIssue) {
        if ("Issue".equals(projectOrIssue.getEntityName())) {
            IssueFactory issueFactory = ComponentAccessor.getIssueFactory();
            MutableIssue issue = issueFactory.getIssue(projectOrIssue);
            Project project = issue.getProjectObject();
            Status status = issue.getStatusObject();
            return new PermissionContextImpl(issue, project, status);
        }
        if ("Project".equals(projectOrIssue.getEntityName())) {
            Project project = ComponentAccessor.getProjectFactory().getProject(projectOrIssue);
            return new PermissionContextImpl(null, project, null);
        }
        throw new IllegalArgumentException("DefaultPermissionContextFactory passed a " + projectOrIssue.getClass().getName() + ": can only accept an Issue or Project");
    }

    @Override
    public PermissionContext getPermissionContext(Issue issue, ActionDescriptor actionDescriptor) {
        if (actionDescriptor == null) {
            return this.getPermissionContext(issue);
        }
        ResultDescriptor unconditionalResult = actionDescriptor.getUnconditionalResult();
        if (unconditionalResult.getStep() == 0 && unconditionalResult.getJoin() != 0) {
            log.warn((Object)("Encountered join " + unconditionalResult.getJoin() + " in result " + actionDescriptor.getName() + "; using default issue permissions"));
            return this.getPermissionContext(issue);
        }
        int newStepId = unconditionalResult.getStep();
        try {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
            if (newStepId == -1) {
                return this.getPermissionContext(issue);
            }
            Status status = workflow.getLinkedStatusObject(workflow.getDescriptor().getStep(newStepId));
            if (status == null) {
                throw new RuntimeException("No status associated with destination step " + newStepId + " for " + issue + " in workflow " + workflow.getName());
            }
            return this.getPermissionContext(issue, status);
        }
        catch (WorkflowException e) {
            log.error((Object)("Could not find workflow associated with issue " + issue), (Throwable)e);
            throw new RuntimeException("Could not find workflow associated with issue " + issue);
        }
    }

    @Override
    public PermissionContext getPermissionContext(OperationContext operationContext, Issue issue) {
        IssueOperation issueOperation = operationContext.getIssueOperation();
        if (issueOperation instanceof WorkflowIssueOperation) {
            ActionDescriptor actionDescriptor = ((WorkflowIssueOperation)issueOperation).getActionDescriptor();
            return this.getPermissionContext(issue, actionDescriptor);
        }
        return this.getPermissionContext(issue);
    }
}

