/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.ofbiz.OfBizLogHelper;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.lang.Pair;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionPoolState;
import org.ofbiz.core.entity.jdbc.interceptors.connection.SQLConnectionInterceptor;

public class PerformanceSQLInterceptor
implements SQLConnectionInterceptor {
    public static final String SQL_PERF_CACHE = "sql.perf.cache";
    private long startTime;

    public void onConnectionTaken(Connection connection, ConnectionPoolState connectionPoolState) {
    }

    public void onConnectionReplaced(Connection connection, ConnectionPoolState connectionPoolState) {
    }

    public void beforeExecution(String sql, List<String> params, Statement statement) {
        this.startTime = System.currentTimeMillis();
    }

    public void afterSuccessfulExecution(String sql, List<String> params, Statement statement, ResultSet resultSet, int i) {
        this.getCache().recordTime(OfBizLogHelper.formatSQL(sql, params), sql, System.currentTimeMillis() - this.startTime);
    }

    public void onException(String sql, List<String> params, Statement statement, SQLException e) {
        this.getCache().recordTime(OfBizLogHelper.formatSQL(sql, params), sql, System.currentTimeMillis() - this.startTime);
    }

    private SQLPerfCache getCache() {
        SQLPerfCache sqlPerfCache = (SQLPerfCache)JiraAuthenticationContextImpl.getRequestCache().get(SQL_PERF_CACHE);
        if (sqlPerfCache == null) {
            SQLPerfCache perfCache = new SQLPerfCache();
            JiraAuthenticationContextImpl.getRequestCache().put(SQL_PERF_CACHE, perfCache);
            return perfCache;
        }
        return sqlPerfCache;
    }

    public static class SQLPerfCache {
        private static final int MAX_STATEMENTS = 500;
        long totalTime = 0L;
        final Map<String, List<Long>> timePerStatement = new HashMap<String, List<Long>>();
        final List<Pair<String, String>> inCallOrder = new ArrayList<Pair<String, String>>();

        public void recordTime(String sqlWithParams, String rawSql, long timeTaken) {
            int numOfStatements = this.inCallOrder.size();
            if (numOfStatements >= 500) {
                if (numOfStatements == 500) {
                    this.inCallOrder.add(Pair.of("More than 500 statements. Skipping remaining statements...", ""));
                }
                return;
            }
            this.totalTime += timeTaken;
            if (!this.timePerStatement.containsKey(rawSql)) {
                this.timePerStatement.put(rawSql, new ArrayList());
            }
            this.timePerStatement.get(rawSql).add(timeTaken);
            this.inCallOrder.add(Pair.of(sqlWithParams, OfBizLogHelper.logTheCallStack()));
        }

        public long getTotalTimeMs() {
            return this.totalTime;
        }

        public long getNumStatements() {
            return this.inCallOrder.size();
        }

        public Map<String, List<Long>> getStatements() {
            ValueComparator vc = new ValueComparator(this.timePerStatement);
            TreeMap<String, List<Long>> result = new TreeMap<String, List<Long>>(vc);
            result.putAll(this.timePerStatement);
            return result;
        }

        public List<Pair<String, String>> getStatementsInCallOrder() {
            return this.inCallOrder;
        }

        static class ValueComparator
        implements Comparator<String> {
            private final Map<String, List<Long>> base;

            ValueComparator(Map<String, List<Long>> base) {
                this.base = base;
            }

            @Override
            public int compare(String key, String key2) {
                List<Long> timings1 = this.base.get(key);
                List<Long> timings2 = this.base.get(key2);
                long totalTiming1 = 0L;
                long totalTiming2 = 0L;
                for (Long timing : timings1) {
                    totalTiming1 += timing.longValue();
                }
                for (Long timing : timings2) {
                    totalTiming2 += timing.longValue();
                }
                if (totalTiming1 < totalTiming2) {
                    return 1;
                }
                if (totalTiming1 == totalTiming2) {
                    if (timings1.size() <= timings2.size()) {
                        return 1;
                    }
                    return -1;
                }
                return -1;
            }
        }
    }
}

