/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.ofbiz.DatabaseIterator;
import com.atlassian.jira.ofbiz.EmptyIterator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.CloseableIterator;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.ListOrderComparator;
import com.atlassian.jira.util.collect.ResolvingComparator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public abstract class PagedDatabaseIterable<E, K>
implements EnclosedIterable<E> {
    private static final int DEFAULT_PAGE_SIZE = 100;
    private final List<K> ids;
    private final Resolver<E, K> keyResolver;
    private final int pageSize;
    private final Supplier<Resolver<GenericValue, E>> resolverFactory = new Supplier<Resolver<GenericValue, E>>(){

        @Override
        public Resolver<GenericValue, E> get() {
            return PagedDatabaseIterable.this.getResolver();
        }
    };
    private final Function<List<K>, OfBizListIterator> iteratorFactory = new Function<List<K>, OfBizListIterator>(){

        @Override
        public OfBizListIterator get(List<K> input) {
            return PagedDatabaseIterable.this.createListIterator(input);
        }
    };

    public PagedDatabaseIterable(List<K> ids) {
        this(ids, null);
    }

    public PagedDatabaseIterable(List<K> ids, Resolver<E, K> keyResolver) {
        this(ids, keyResolver, 100);
    }

    public PagedDatabaseIterable(List<K> ids, Resolver<E, K> keyResolver, int pageSize) {
        this.ids = Collections.unmodifiableList(Assertions.notNull("ids", ids));
        this.keyResolver = keyResolver;
        this.pageSize = pageSize;
    }

    CloseableIterator<E> iterator() {
        if (this.isEmpty()) {
            return new EmptyIterator();
        }
        if (this.keyResolver != null) {
            return new SortedIterator<E, K>(this.keyResolver, this.ids, new PagingIterator<E, K>(this.ids, this.pageSize, this.resolverFactory, this.iteratorFactory));
        }
        return new PagingIterator<E, K>(this.ids, this.pageSize, this.resolverFactory, this.iteratorFactory);
    }

    @Override
    public final void foreach(Consumer<E> consumer) {
        CloseableIterator.Functions.foreach(this.iterator(), consumer);
    }

    protected abstract OfBizListIterator createListIterator(List<K> var1);

    protected abstract Resolver<GenericValue, E> getResolver();

    @Override
    public final int size() {
        return this.ids.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static final class PagingIterator<E, K>
    implements CloseableIterator<E> {
        private CloseableIterator<E> delegate = new EmptyIterator();
        private int end = -1;
        private final List<K> ids;
        private final int pageSize;
        private final Supplier<Resolver<GenericValue, E>> resolverFactory;
        private final Function<List<K>, OfBizListIterator> iteratorFactory;

        public PagingIterator(List<K> ids, int pageSize, Supplier<Resolver<GenericValue, E>> resolverFactory, Function<List<K>, OfBizListIterator> iteratorFactory) {
            this.ids = ids;
            this.pageSize = pageSize;
            this.resolverFactory = resolverFactory;
            this.iteratorFactory = iteratorFactory;
            this.createDelegate();
        }

        @Override
        public E next() {
            if (!this.delegate.hasNext() && this.hasMorePages()) {
                this.createDelegate();
            }
            return this.delegate.next();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext() || this.hasMorePages();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        private boolean hasMorePages() {
            return this.end < this.ids.size() - 1;
        }

        private void createDelegate() {
            int start = this.end + 1;
            this.end = Math.min(this.end + this.pageSize, this.ids.size());
            this.delegate.close();
            this.delegate = new DatabaseIterator<E>(this.resolverFactory.get(), this.iteratorFactory.get(this.ids.subList(start, this.end)));
        }
    }

    private static final class SortedIterator<E, K>
    implements CloseableIterator<E> {
        private final Iterator<E> it;

        SortedIterator(Resolver<E, K> keyResolver, List<K> ids, PagingIterator<E, K> delegate) {
            ArrayList list = new ArrayList(new CloseableIterator.ListResolver().get(delegate));
            Collections.sort(list, new ResolvingComparator<E, K>(keyResolver, new ListOrderComparator<K>(ids)));
            this.it = list.iterator();
        }

        @Override
        public E next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public void close() {
        }
    }
}

