/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.util.dbc.Assertions;

final class DatabaseField {
    private final String table;
    private final String field;
    private final int hash;

    DatabaseField(String table, String field) {
        this.table = Assertions.notNull("table", table);
        this.field = Assertions.notNull("field", field);
        this.hash = this.computeHash();
    }

    public int hashCode() {
        return this.hash;
    }

    private int computeHash() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.table.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        DatabaseField other = (DatabaseField)obj;
        return this.table.equals(other.table) && this.field.equals(other.field);
    }

    public String toString() {
        return this.table + "." + this.field;
    }

    String table() {
        return this.table;
    }

    String field() {
        return this.field;
    }
}

