/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.notification.ProjectNotificationsSchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.TreeSet;

public class DefaultProjectNotificationsSchemeHelper
implements ProjectNotificationsSchemeHelper {
    private final NotificationSchemeManager notificationSchemeManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    public DefaultProjectNotificationsSchemeHelper(NotificationSchemeManager notificationSchemeManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager) {
        this.notificationSchemeManager = notificationSchemeManager;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    @Override
    public List<Project> getSharedProjects(Scheme notificationsScheme) {
        TreeSet sharedProjects = Sets.newTreeSet(ProjectNameComparator.COMPARATOR);
        List<Project> projects = this.notificationSchemeManager.getProjects(notificationsScheme);
        for (Project project : projects) {
            if (!this.hasEditPermission(this.authenticationContext.getLoggedInUser(), project)) continue;
            sharedProjects.add(project);
        }
        return Lists.newArrayList((Iterable)sharedProjects);
    }

    boolean hasEditPermission(User user, Project project) {
        return ProjectAction.EDIT_PROJECT_CONFIG.hasPermission(this.permissionManager, user, project);
    }
}

