/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.MentionIssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.mention.MentionFinder;
import com.atlassian.jira.mention.MentionService;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.Users;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class MentionServiceImpl
implements MentionService {
    private final MentionFinder finder;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final EventPublisher eventPublisher;
    private final ChangeHistoryManager changeHistoryManager;

    public MentionServiceImpl(MentionFinder finder, UserManager userManager, PermissionManager permissionManager, EventPublisher eventPublisher, ChangeHistoryManager changeHistoryManager) {
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.eventPublisher = eventPublisher;
        this.changeHistoryManager = changeHistoryManager;
        this.finder = (MentionFinder)Preconditions.checkNotNull((Object)finder, (Object)"finder");
    }

    @Override
    public void sendCommentMentions(User remoteUser, Set<NotificationRecipient> currentRecipients, Comment comment, Comment originalComment) {
        if (!this.isUserAbleToMention(remoteUser)) {
            return;
        }
        String mentionText = comment.getBody();
        Issue issue = comment.getIssue();
        Set<User> mentionedUsers = this.getMentionedUsers(mentionText, issue);
        if (originalComment != null) {
            Set<User> originalMentionedUsers = this.getMentionedUsers(originalComment.getBody(), issue);
            mentionedUsers.removeAll(originalMentionedUsers);
        }
        if (!mentionedUsers.isEmpty()) {
            this.eventPublisher.publish((Object)new MentionIssueEvent(issue, remoteUser, mentionedUsers, mentionText, "comment", currentRecipients));
        }
    }

    @Override
    public void sendIssueEditMentions(User remoteUser, Set<NotificationRecipient> currentRecipients, Issue issue, Comment comment) {
        if (!this.isUserAbleToMention(remoteUser)) {
            return;
        }
        String mentionText = issue.getDescription();
        Set<User> mentionedUsers = this.getMentionedUsers(mentionText, issue);
        List<ChangeHistory> allChangeHistories = this.changeHistoryManager.getChangeHistories(issue);
        boolean containsDescriptionChanges = false;
        if (!allChangeHistories.isEmpty()) {
            ChangeHistory last = (ChangeHistory)Iterables.getLast(allChangeHistories);
            List<ChangeItemBean> changeItemBeans = last.getChangeItemBeans();
            for (ChangeItemBean changeItemBean : changeItemBeans) {
                if (!changeItemBean.getField().equals("description")) continue;
                Set<User> lastMentionedUsers = this.getMentionedUsers(changeItemBean.getFromString(), issue);
                mentionedUsers.removeAll(lastMentionedUsers);
                containsDescriptionChanges = true;
                break;
            }
        }
        if (!mentionedUsers.isEmpty() && containsDescriptionChanges) {
            this.eventPublisher.publish((Object)new MentionIssueEvent(issue, remoteUser, mentionedUsers, mentionText, "description", currentRecipients));
        }
        if (comment != null) {
            this.sendCommentMentions(remoteUser, currentRecipients, comment, null);
        }
    }

    @Override
    public void sendIssueCreateMentions(User remoteUser, Set<NotificationRecipient> currentRecipients, Issue issue) {
        if (!this.isUserAbleToMention(remoteUser)) {
            return;
        }
        String mentionText = issue.getDescription();
        Set<User> mentionedUsers = this.getMentionedUsers(mentionText, issue);
        if (!mentionedUsers.isEmpty()) {
            this.eventPublisher.publish((Object)new MentionIssueEvent(issue, remoteUser, mentionedUsers, mentionText, "description", currentRecipients));
        }
    }

    @Override
    public boolean isUserAbleToMention(User remoteUser) {
        return !Users.isAnonymous(remoteUser) && this.isUserAbleToBrowseUsers(remoteUser);
    }

    private boolean isUserAbleToBrowseUsers(User remoteUser) {
        return this.permissionManager.hasPermission(27, remoteUser);
    }

    private Set<User> getMentionedUsers(String mentionText, Issue issue) {
        LinkedHashSet<User> mentionedUsers = new LinkedHashSet<User>();
        Iterable<String> allMentionedUsernames = this.finder.getMentionedUsernames(mentionText);
        for (String username : allMentionedUsernames) {
            User user = this.userManager.getUser(username);
            if (user == null || !this.permissionManager.hasPermission(10, issue, user)) continue;
            mentionedUsers.add(user);
        }
        return mentionedUsers;
    }
}

