/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention;

import com.atlassian.jira.mention.MentionFinder;
import com.google.common.collect.ImmutableSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class MentionFinderImpl
implements MentionFinder {
    private static final Pattern USER_PROFILE_WIKI_MARKUP_LINK_PATTERN = Pattern.compile("\\[[~@]*[^\\\\,]+?\\]");

    @Override
    public Iterable<String> getMentionedUsernames(String content) {
        if (StringUtils.isBlank((String)content)) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder mentions = ImmutableSet.builder();
        Matcher wikiMatcher = USER_PROFILE_WIKI_MARKUP_LINK_PATTERN.matcher(content);
        while (wikiMatcher.find()) {
            String markup = content.substring(wikiMatcher.start(), wikiMatcher.end());
            String username = markup.substring(2, markup.length() - 1);
            mentions.add((Object)username);
        }
        return mentions.build();
    }
}

