/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.JiraKeyUtils;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class TemplateIssue
implements Issue {
    private static final Logger log = Logger.getLogger(TemplateIssue.class);
    private final Issue issue;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final CustomFieldManager customFieldManager;
    private final JiraDurationUtils jiraDurationUtils;
    private final AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory;
    private AggregateTimeTrackingBean aggregateBean;

    public TemplateIssue(Issue issue, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, CustomFieldManager customFieldManager, JiraDurationUtils jiraDurationUtils, AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory) {
        this.issue = issue;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.customFieldManager = customFieldManager;
        this.jiraDurationUtils = jiraDurationUtils;
        this.aggregateTimeTrackingCalculatorFactory = aggregateTimeTrackingCalculatorFactory;
    }

    @Override
    public Long getId() {
        return this.issue.getId();
    }

    @Override
    public GenericValue getProject() {
        return this.issue.getProject();
    }

    @Override
    public Project getProjectObject() {
        return this.issue.getProjectObject();
    }

    @Override
    public GenericValue getIssueType() {
        return this.issue.getIssueType();
    }

    @Override
    public IssueType getIssueTypeObject() {
        return this.issue.getIssueTypeObject();
    }

    @Override
    public String getSummary() {
        return this.issue.getSummary();
    }

    @Override
    public User getAssignee() {
        return this.issue.getAssignee();
    }

    @Override
    public String getAssigneeId() {
        return this.issue.getAssigneeId();
    }

    @Override
    public User getAssigneeUser() {
        return this.issue.getAssigneeUser();
    }

    @Override
    public Collection<GenericValue> getComponents() {
        return this.issue.getComponents();
    }

    @Override
    public Collection<ProjectComponent> getComponentObjects() {
        return this.issue.getComponentObjects();
    }

    @Override
    public User getReporter() {
        return this.issue.getReporter();
    }

    @Override
    public String getReporterId() {
        return this.issue.getReporterId();
    }

    @Override
    public User getReporterUser() {
        return this.issue.getReporterUser();
    }

    @Override
    public String getDescription() {
        return this.issue.getDescription();
    }

    public String getHtmlDescription() {
        try {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(this.issue);
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem("description");
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            String renderedContent = this.rendererManager.getRenderedContent(rendererType, this.issue.getDescription(), this.issue.getIssueRenderContext());
            return renderedContent.replaceAll("<p>", "<p style='margin-top:0;margin-bottom:10px;'>");
        }
        catch (Exception e) {
            log.warn((Object)("Unable to produce rendered version of the description for the issue " + this.issue.getKey()), (Throwable)e);
            return JiraKeyUtils.linkBugKeys(this.issue.getDescription());
        }
    }

    @Override
    public String getEnvironment() {
        return this.issue.getEnvironment();
    }

    public String getHtmlEnvironment() {
        try {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(this.issue);
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem("environment");
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            String renderedContent = this.rendererManager.getRenderedContent(rendererType, this.issue.getEnvironment(), this.issue.getIssueRenderContext());
            return renderedContent.replaceAll("<p>", "<p style='margin-top:0;margin-bottom:10px;'>");
        }
        catch (Exception e) {
            log.warn((Object)("Unable to produce rendered version of the environment for the issue " + this.issue.getKey()), (Throwable)e);
            return JiraKeyUtils.linkBugKeys(this.issue.getEnvironment());
        }
    }

    @Override
    public Collection<Version> getAffectedVersions() {
        return this.issue.getAffectedVersions();
    }

    @Override
    public Collection<Version> getFixVersions() {
        return this.issue.getFixVersions();
    }

    @Override
    public Timestamp getDueDate() {
        return this.issue.getDueDate();
    }

    @Override
    public GenericValue getSecurityLevel() {
        return this.issue.getSecurityLevel();
    }

    @Override
    public Long getSecurityLevelId() {
        return this.issue.getSecurityLevelId();
    }

    @Override
    public GenericValue getPriority() {
        return this.issue.getPriority();
    }

    @Override
    public Priority getPriorityObject() {
        return this.issue.getPriorityObject();
    }

    @Override
    public String getResolutionId() {
        return this.issue.getResolutionId();
    }

    @Override
    public GenericValue getResolution() {
        return this.issue.getResolution();
    }

    @Override
    public Resolution getResolutionObject() {
        return this.issue.getResolutionObject();
    }

    @Override
    public String getKey() {
        return this.issue.getKey();
    }

    @Override
    public Long getVotes() {
        return this.issue.getVotes();
    }

    @Override
    public Long getWatches() {
        return this.issue.getWatches();
    }

    @Override
    public Timestamp getCreated() {
        return this.issue.getCreated();
    }

    @Override
    public Timestamp getResolutionDate() {
        return this.issue.getResolutionDate();
    }

    @Override
    public Timestamp getUpdated() {
        return this.issue.getUpdated();
    }

    @Override
    public Long getWorkflowId() {
        return this.issue.getWorkflowId();
    }

    @Override
    public Object getCustomFieldValue(CustomField customField) {
        return this.issue.getCustomFieldValue(customField);
    }

    public CustomField getCustomField(String id) {
        return this.customFieldManager.getCustomFieldObject(id);
    }

    public Object getCustomFieldValue(String id) {
        CustomField cf = this.customFieldManager.getCustomFieldObject(id);
        if (cf == null) {
            log.warn((Object)("Velocity template referenced nonexistent custom field '" + id + "'"));
            return null;
        }
        return this.getCustomFieldValue(cf);
    }

    @Override
    public GenericValue getStatus() {
        return this.issue.getStatus();
    }

    @Override
    public Status getStatusObject() {
        return this.issue.getStatusObject();
    }

    @Override
    public Long getOriginalEstimate() {
        return this.issue.getOriginalEstimate();
    }

    @Override
    public Long getEstimate() {
        return this.issue.getEstimate();
    }

    @Override
    public Long getTimeSpent() {
        return this.issue.getTimeSpent();
    }

    public Long getAggregateOriginalEstimate() {
        return this.getAggregateBean().getOriginalEstimate();
    }

    public Long getAggregateRemainingEstimate() {
        return this.getAggregateBean().getRemainingEstimate();
    }

    public Long getAggregateTimeSpent() {
        return this.getAggregateBean().getTimeSpent();
    }

    private AggregateTimeTrackingBean getAggregateBean() {
        if (this.aggregateBean == null) {
            this.aggregateBean = this.aggregateTimeTrackingCalculatorFactory.getCalculator(this.issue).getAggregates(this.issue);
        }
        return this.aggregateBean;
    }

    @Override
    public Object getExternalFieldValue(String fieldId) {
        return this.issue.getExternalFieldValue(fieldId);
    }

    @Override
    public boolean isSubTask() {
        return this.issue.isSubTask();
    }

    @Override
    public Long getParentId() {
        return this.issue.getParentId();
    }

    @Override
    public boolean isCreated() {
        return this.issue.isCreated();
    }

    @Override
    public Issue getParentObject() {
        return this.issue.getParentObject();
    }

    @Override
    public GenericValue getParent() {
        return this.issue.getParent();
    }

    @Override
    public Collection<GenericValue> getSubTasks() {
        return this.issue.getSubTasks();
    }

    @Override
    public Collection<Issue> getSubTaskObjects() {
        return this.issue.getSubTaskObjects();
    }

    @Override
    public boolean isEditable() {
        return this.issue.isEditable();
    }

    @Override
    public IssueRenderContext getIssueRenderContext() {
        return this.issue.getIssueRenderContext();
    }

    @Override
    public Collection<Attachment> getAttachments() {
        return this.issue.getAttachments();
    }

    @Override
    public String getString(String name) {
        return this.issue.getString(name);
    }

    @Override
    public Timestamp getTimestamp(String name) {
        return this.issue.getTimestamp(name);
    }

    @Override
    public Set<Label> getLabels() {
        return this.issue.getLabels();
    }

    @Override
    public Long getLong(String name) {
        return this.issue.getLong(name);
    }

    @Override
    public GenericValue getGenericValue() {
        return this.issue.getGenericValue();
    }

    @Override
    public void store() {
    }

    public String getNiceTimeOriginalEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.issue.getOriginalEstimate(), i18n);
    }

    public String getNiceTimeEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.issue.getEstimate(), i18n);
    }

    public String getNiceTimeSpent(I18nHelper i18n) {
        return this.convertToNiceTime(this.issue.getTimeSpent(), i18n);
    }

    public boolean isAnyAggregateDifferent() {
        return this.isTimeAndAggregateDifferent(this.getOriginalEstimate(), this.getAggregateOriginalEstimate()) || this.isTimeAndAggregateDifferent(this.getEstimate(), this.getAggregateRemainingEstimate()) || this.isTimeAndAggregateDifferent(this.getTimeSpent(), this.getAggregateTimeSpent());
    }

    private boolean isTimeAndAggregateDifferent(Long time, Long aggregate) {
        if (time == null) {
            return aggregate != null;
        }
        return !time.equals(aggregate);
    }

    public String getNiceTimeAggregateOriginalEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.getAggregateOriginalEstimate(), i18n);
    }

    public String getNiceTimeAggregateRemainingEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.getAggregateRemainingEstimate(), i18n);
    }

    public String getNiceTimeAggregateTimeSpent(I18nHelper i18n) {
        return this.convertToNiceTime(this.getAggregateTimeSpent(), i18n);
    }

    private String convertToNiceTime(Long time, I18nHelper i18n) {
        if (time == null) {
            return i18n.getText("viewissue.timetracking.unknown");
        }
        return this.jiraDurationUtils.getFormattedDuration(time, i18n.getLocale());
    }
}

