/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.NotificationRecipientProcessor;
import com.atlassian.jira.mail.TemplateContext;
import com.atlassian.jira.mail.TemplateIssue;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.mail.MailThreader;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class MailingListCompiler {
    private static final Logger log = Logger.getLogger(MailingListCompiler.class);
    private static final String GETS_COMMENT_AND_ORIGINAL = "commentplusoriginal";
    private static final String GETS_COMMENT_NO_ORIGINAL = "commentnooriginal";
    private static final String NOCOMMENT = "nocomment";
    private final TemplateManager templateManager;
    private final ProjectRoleManager projectRoleManager;

    public MailingListCompiler(TemplateManager templateManager, ProjectRoleManager projectRoleManager) {
        this.templateManager = templateManager;
        this.projectRoleManager = projectRoleManager;
    }

    @Deprecated
    public static String getEmailAddresses(Set<String> addresses) {
        return Joiner.on((String)",").join(addresses);
    }

    public void sendLists(Set<NotificationRecipient> recipients, String sender, String senderFrom, Long templateId, String baseUrl, Map<String, Object> contextParams, MailThreader threader) throws VelocityException {
        NotificationCompiler compiler = new NotificationCompiler(recipients, sender, senderFrom, templateId, baseUrl, contextParams, threader);
        Object eventParams = contextParams.get("params");
        if (eventParams != null) {
            Object commentObject = contextParams.get("comment");
            Object worklogObject = contextParams.get("worklog");
            if (worklogObject != null) {
                Worklog worklog = (Worklog)worklogObject;
                ProjectRole roleLevel = worklog.getRoleLevel();
                String roleLevelName = roleLevel == null ? null : roleLevel.getName();
                Worklog originalWorklog = (Worklog)((Map)eventParams).get("originalworklog");
                String originalRoleLevelName = null;
                String originalGroupLevel = null;
                if (originalWorklog != null) {
                    ProjectRole originalRoleLevel = originalWorklog.getRoleLevel();
                    originalRoleLevelName = originalRoleLevel == null ? null : originalRoleLevel.getName();
                    originalGroupLevel = originalWorklog.getGroupLevel();
                }
                compiler.sendForEvent((Map)eventParams, worklog.getGroupLevel(), roleLevelName, originalGroupLevel, originalRoleLevelName);
            } else if (commentObject != null) {
                ProjectRole roleLevel;
                Comment comment = (Comment)commentObject;
                Comment originalComment = (Comment)((Map)eventParams).get("originalcomment");
                String originalRoleLevelName = null;
                String originalGroupLevel = null;
                if (originalComment != null) {
                    ProjectRole originalRoleLevel = originalComment.getRoleLevel();
                    originalRoleLevelName = originalRoleLevel == null ? null : originalRoleLevel.getName();
                    originalGroupLevel = originalComment.getGroupLevel();
                }
                String roleLevelName = (roleLevel = comment.getRoleLevel()) == null ? null : roleLevel.getName();
                compiler.sendForEvent((Map)eventParams, comment.getGroupLevel(), roleLevelName, originalGroupLevel, originalRoleLevelName);
            } else {
                log.debug((Object)"The event does not have a comment or a worklog. Sending to all recipients.");
                compiler.sendToAll();
            }
        } else {
            log.debug((Object)"Do not have any context params. Sending to all recipients.");
            compiler.sendToAll();
        }
    }

    private Map<String, Map<String, Set<NotificationRecipient>>> groupEmailsByType(Set<NotificationRecipient> recipients, String group, String role, String originalGroup, String originalRole, TemplateIssue issue, boolean sendOnlyWhenInGroup) {
        HashMap<String, Map<String, Set<NotificationRecipient>>> recipientEmailsByType = new HashMap<String, Map<String, Set<NotificationRecipient>>>();
        HashMap usersGettingCommentAndOriginal = new HashMap();
        HashMap usersGettingCommentNoOriginal = new HashMap();
        HashMap<String, HashSet<NotificationRecipient>> usersNotGettingComment = new HashMap<String, HashSet<NotificationRecipient>>();
        recipientEmailsByType.put(GETS_COMMENT_AND_ORIGINAL, usersGettingCommentAndOriginal);
        recipientEmailsByType.put(GETS_COMMENT_NO_ORIGINAL, usersGettingCommentNoOriginal);
        recipientEmailsByType.put(NOCOMMENT, usersNotGettingComment);
        for (NotificationRecipient recipient : recipients) {
            HashMap<String, HashSet<NotificationRecipient>> currentGroup;
            if (this.recipientHasVisibility(group, role, recipient, issue)) {
                currentGroup = this.recipientHasVisibility(originalGroup, originalRole, recipient, issue) ? usersGettingCommentAndOriginal : usersGettingCommentNoOriginal;
            } else {
                if (sendOnlyWhenInGroup) continue;
                currentGroup = usersNotGettingComment;
            }
            String format = recipient.getFormat();
            HashSet<NotificationRecipient> currentUsers = (HashSet<NotificationRecipient>)currentGroup.get(format);
            if (currentUsers == null) {
                currentUsers = new HashSet<NotificationRecipient>();
                currentGroup.put(format, currentUsers);
            }
            currentUsers.add(recipient);
        }
        return recipientEmailsByType;
    }

    private boolean recipientHasVisibility(String group, String role, NotificationRecipient recipient, TemplateIssue issue) {
        return group == null && role == null || group != null && recipient.isInGroup(group) || role != null && issue != null && this.isInRole(recipient, issue.getProjectObject(), role);
    }

    private boolean isInRole(NotificationRecipient recipient, Project project, String role) {
        User user = recipient.getUserRecipient();
        if (user == null) {
            return false;
        }
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(role);
        return projectRole != null && this.projectRoleManager.isUserInProjectRole(user, projectRole, project);
    }

    private void addMailsToQueue(Set<NotificationRecipient> textRecipients, Long templateId, final String format, final String baseUrl, final Map<String, Object> contextParams, final String sender, final String senderFrom, final MailThreader threader) throws VelocityException {
        final String subjectTemplate = this.templateManager.getTemplateContent(templateId, "subject");
        final String bodyTemplate = this.templateManager.getTemplateContent(templateId, format);
        if (!textRecipients.isEmpty()) {
            NotificationRecipientProcessor processor = new NotificationRecipientProcessor(textRecipients){

                @Override
                void processRecipient(NotificationRecipient recipient) throws Exception {
                    User recipientUser = recipient.getUserRecipient();
                    String recipientEmail = recipient.getEmail();
                    if (recipientEmail == null || recipientEmail.length() == 0) {
                        if (recipientUser == null) {
                            log.warn((Object)("Can not send e-mail, e-mail address ('" + recipientEmail + "') not set. Skipping..."));
                        } else {
                            String fullName = recipientUser.getDisplayName();
                            String userName = recipientUser.getName();
                            log.warn((Object)("Can not send e-mail to '" + fullName + "' [" + userName + "]," + " e-mail address ('" + recipientEmail + "') not set. Skipping..."));
                        }
                    } else {
                        I18nBean i18nBean = new I18nBean(recipientUser);
                        contextParams.put("i18n", i18nBean);
                        TemplateContext templateContext = (TemplateContext)contextParams.get("context");
                        if (templateContext != null) {
                            contextParams.put("eventTypeName", templateContext.getEventTypeName(i18nBean));
                        }
                        OutlookDate formatter = new OutlookDate(i18nBean.getLocale());
                        contextParams.put("dateformatter", formatter);
                        contextParams.put("lfbean", LookAndFeelBean.getInstance(ComponentManager.getComponent(ApplicationProperties.class)));
                        if (recipientUser != null) {
                            contextParams.put("recipient", recipientUser);
                        }
                        String subjectForRecipient = ManagerFactory.getVelocityManager().getEncodedBodyForContent(subjectTemplate, baseUrl, contextParams);
                        String body = ManagerFactory.getVelocityManager().getEncodedBodyForContent(bodyTemplate, baseUrl, contextParams);
                        Email email = MailingListCompiler.createEmail(recipientEmail, sender, senderFrom, subjectForRecipient, body, MailingListCompiler.getMimeTypeForFormat(format));
                        SingleMailQueueItem item = new SingleMailQueueItem((com.atlassian.mail.Email)email);
                        item.setMailThreader(threader);
                        ManagerFactory.getMailQueue().addItem((MailQueueItem)item);
                    }
                }

                @Override
                void handleException(NotificationRecipient recipient, Exception ex) {
                    if (recipient == null) {
                        log.error((Object)"Failed adding mail, notification recipient was null", (Throwable)ex);
                    } else {
                        log.error((Object)("Failed adding mail for notification recipient: [email=" + recipient.getEmail() + ", user=" + recipient.getUserRecipient() + "]"), (Throwable)ex);
                    }
                }
            };
            processor.process();
        }
    }

    private static String getMimeTypeForFormat(String format) {
        if ("html".equals(format)) {
            return "text/html";
        }
        if ("text".equals(format)) {
            return "text/plain";
        }
        return format;
    }

    private static Email createEmail(String recipient, String sender, String senderFrom, String subject, String body, String mimeType) {
        Email email = new Email(recipient);
        email.setFrom(sender);
        email.setFromName(senderFrom);
        email.setSubject(subject == null ? "" : subject);
        email.setBody(body);
        email.setMimeType(mimeType);
        return email;
    }

    private class NotificationCompiler {
        private final Set<NotificationRecipient> recipients;
        private final String sender;
        private final String senderFrom;
        private final Long templateId;
        private final String baseUrl;
        private final Map<String, Object> contextParams;
        private final MailThreader threader;

        public NotificationCompiler(Set<NotificationRecipient> recipients, String sender, String senderFrom, Long templateId, String baseUrl, Map<String, Object> contextParams, MailThreader threader) {
            this.recipients = recipients;
            this.sender = sender;
            this.senderFrom = senderFrom;
            this.templateId = templateId;
            this.baseUrl = baseUrl;
            this.contextParams = contextParams;
            this.threader = threader;
        }

        public void sendForEvent(Map eventParams, String groupLevel, String roleLevel, String originalGroupLevel, String originalRoleLevel) throws VelocityException {
            Object eventSource = eventParams.get("eventsource");
            if (eventSource != null) {
                log.debug((Object)"Do have an event source so from a comment or workflow");
                if ("action".equals(eventSource)) {
                    log.debug((Object)"Event source is action");
                    this.sendLists(groupLevel, roleLevel, originalGroupLevel, originalRoleLevel, true);
                } else if ("workflow".equals(eventSource)) {
                    log.debug((Object)"Event source is workflow");
                    this.sendLists(groupLevel, roleLevel, originalGroupLevel, originalRoleLevel, false);
                } else {
                    log.debug((Object)"Event source is unknown, this should not happen");
                    this.sendNoLevelsIgnoreGroup();
                }
            } else {
                log.debug((Object)"No event source so must be from a subscription");
                this.sendNoLevelsIgnoreGroup();
            }
        }

        public void sendToAll() throws VelocityException {
            this.sendNoLevelsIgnoreGroup();
        }

        private void sendNoLevelsIgnoreGroup() throws VelocityException {
            this.sendLists(null, null, null, null, false);
        }

        private void sendLists(String groupLevel, String roleLevel, String originalGroupLevel, String originalRoleLevel, boolean sendOnlyWhenInGroup) throws VelocityException {
            TemplateIssue issue = (TemplateIssue)this.contextParams.get("issue");
            Map recipientEmailsByType = MailingListCompiler.this.groupEmailsByType(this.recipients, groupLevel, roleLevel, originalGroupLevel, originalRoleLevel, issue, sendOnlyWhenInGroup);
            this.addEmailsToQueue((Map)recipientEmailsByType.get(MailingListCompiler.GETS_COMMENT_AND_ORIGINAL));
            this.contextParams.remove("originalcomment");
            this.contextParams.remove("originalworklog");
            this.addEmailsToQueue((Map)recipientEmailsByType.get(MailingListCompiler.GETS_COMMENT_NO_ORIGINAL));
            this.contextParams.remove("comment");
            this.addEmailsToQueue((Map)recipientEmailsByType.get(MailingListCompiler.NOCOMMENT));
        }

        private void addEmailsToQueue(Map<String, Set<NotificationRecipient>> userSets) throws VelocityException {
            for (Map.Entry<String, Set<NotificationRecipient>> entry : userSets.entrySet()) {
                String format = entry.getKey();
                Set<NotificationRecipient> users = entry.getValue();
                MailingListCompiler.this.addMailsToQueue(users, this.templateId, format, this.baseUrl, this.contextParams, this.sender, this.senderFrom, this.threader);
            }
        }
    }
}

