/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.core.util.StringUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.MailService;
import com.atlassian.jira.mail.RenderingMailQueueItem;
import com.atlassian.jira.mail.TemplateContext;
import com.atlassian.jira.mail.TemplateContextFactory;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MailServiceImpl
implements MailService {
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory beanFactory;
    private final MailQueue mailQueue;
    private final TemplateContextFactory templateContextFactory;

    public MailServiceImpl(ApplicationProperties applicationProperties, I18nHelper.BeanFactory beanFactory, MailQueue mailQueue, TemplateContextFactory templateContextFactory) {
        this.applicationProperties = applicationProperties;
        this.beanFactory = beanFactory;
        this.mailQueue = mailQueue;
        this.templateContextFactory = templateContextFactory;
    }

    @Override
    public void sendRenderedMail(User from, NotificationRecipient recipient, String subjectTemplatePath, String bodyTemplatePath, Map<String, Object> context) {
        User toUser = recipient.getUserRecipient();
        Locale emailLocale = toUser != null ? I18nBean.getLocaleFromUser(toUser) : this.applicationProperties.getDefaultLocale();
        I18nHelper i18nHelper = this.beanFactory.getInstance(emailLocale);
        if (context.containsKey("issue")) {
            Issue issue = (Issue)context.get("issue");
            IssueEvent issueEvent = new IssueEvent(issue, Maps.newHashMap(), from, 0L);
            TemplateContext templateContext = this.templateContextFactory.getTemplateContext(issueEvent);
            Map<String, Object> templateParams = templateContext.getTemplateParams();
            context.putAll(templateParams);
        }
        HashMap contextParams = Maps.newHashMap(context);
        contextParams.put("i18n", i18nHelper);
        OutlookDate formatter = new OutlookDate(emailLocale);
        contextParams.put("dateformatter", formatter);
        contextParams.put("lfbean", LookAndFeelBean.getInstance(this.applicationProperties));
        contextParams.put("baseurl", this.applicationProperties.getString("jira.baseurl"));
        Email email = new Email(recipient.getEmail());
        String format = recipient.getFormat();
        email.setMimeType(MailServiceImpl.getMimeTypeForFormat(format));
        email.setFromName(this.getSenderFrom(from));
        email.setFrom(from.getEmailAddress());
        RenderingMailQueueItem item = new RenderingMailQueueItem(email, subjectTemplatePath, bodyTemplatePath, contextParams);
        this.mailQueue.addItem((MailQueueItem)item);
    }

    private static String getMimeTypeForFormat(String format) {
        if ("html".equals(format)) {
            return "text/html";
        }
        if ("text".equals(format)) {
            return "text/plain";
        }
        return format;
    }

    private String getSenderFrom(User user) {
        String email;
        String name;
        String from = this.applicationProperties.getDefaultBackedString("jira.email.fromheader.format");
        if (from == null) {
            return null;
        }
        if (Users.isAnonymous(user)) {
            name = "Anonymous";
        } else {
            try {
                String fullName = user.getDisplayName();
                name = org.apache.commons.lang.StringUtils.isBlank((String)fullName) ? user.getName() : fullName;
            }
            catch (Exception exception) {
                try {
                    name = user.getName();
                }
                catch (Exception exception2) {
                    name = "";
                }
            }
        }
        try {
            email = user != null ? user.getEmailAddress() : "";
        }
        catch (Exception exception) {
            email = "";
        }
        String hostname = user != null && email != null ? email.substring(email.indexOf("@") + 1) : "";
        from = StringUtils.replaceAll((String)from, (String)"${fullname}", (String)name);
        from = StringUtils.replaceAll((String)from, (String)"${email}", (String)email);
        from = StringUtils.replaceAll((String)from, (String)"${email.hostname}", (String)hostname);
        return from;
    }
}

