/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.StringUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.mail.JiraMailThreader;
import com.atlassian.jira.mail.MailingListCompiler;
import com.atlassian.jira.mail.TemplateContext;
import com.atlassian.jira.mail.TemplateContextFactory;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class IssueMailQueueItem
extends AbstractMailQueueItem {
    private static final Logger log = Logger.getLogger(IssueMailQueueItem.class);
    private final TemplateContextFactory templateContextFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final MailingListCompiler mailingListCompiler;
    private final TemplateManager templateManager;
    IssueEvent event;
    Long templateId;
    Set<NotificationRecipient> recipientList;
    String notificationType;

    public IssueMailQueueItem(TemplateContextFactory templateContextFactory, IssueEvent event, Long templateId, Set<NotificationRecipient> recipientList, String notificationType, JiraAuthenticationContext authenticationContext, MailingListCompiler mailingListCompiler, TemplateManager templateManager) {
        this.templateContextFactory = templateContextFactory;
        this.event = event;
        this.templateId = templateId;
        this.recipientList = recipientList;
        this.notificationType = notificationType;
        this.authenticationContext = authenticationContext;
        this.mailingListCompiler = mailingListCompiler;
        this.templateManager = templateManager;
    }

    public String getSubject() {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        try {
            String subjectTemplate = this.templateManager.getTemplateContent(this.templateId, "subject");
            Map<String, Object> contextParams = this.getIssueContextParams(this.event);
            contextParams.put("i18n", i18n);
            contextParams.put("eventTypeName", ((TemplateContext)contextParams.get("context")).getEventTypeName(i18n));
            OutlookDate formatter = new OutlookDate(i18n.getLocale());
            contextParams.put("dateformatter", formatter);
            return ManagerFactory.getVelocityManager().getEncodedBodyForContent(subjectTemplate, (String)this.event.getParams().get("baseurl"), contextParams);
        }
        catch (Exception e) {
            log.error((Object)"Could not determine subject", (Throwable)e);
            return i18n.getText("bulk.bean.initialise.error");
        }
    }

    public IssueEvent getEvent() {
        return this.event;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void send() throws MailException {
        this.incrementSendCount();
        Issue issue = this.event.getIssue();
        try {
            SMTPMailServer smtp = MailFactory.getServerManager().getDefaultSMTPMailServer();
            if (smtp == null) {
                log.warn((Object)"There is no default SMTP Mail server so mail cannot be sent");
            } else {
                if (issue == null) {
                    throw new MailException("Notification not sent; issue no longer exists [event=" + this.event + "]");
                }
                GenericValue project = issue.getProject();
                String sender = OFBizPropertyUtils.getPropertySet(project).getString("jira.project.email.sender");
                if (!this.recipientList.isEmpty()) {
                    Iterator<NotificationRecipient> iterator = this.recipientList.iterator();
                    while (iterator.hasNext()) {
                        NotificationRecipient recipient = iterator.next();
                        if (ManagerFactory.getPermissionManager().hasPermission(10, issue, recipient.getUserRecipient())) continue;
                        iterator.remove();
                    }
                    JiraMailThreader threader = new JiraMailThreader(this.event.getEventTypeId(), issue.getLong("id"));
                    Map<String, Object> contextParams = this.getIssueContextParams(this.event);
                    this.mailingListCompiler.sendLists(this.recipientList, sender, this.getSenderFrom(this.event, contextParams), this.templateId, (String)this.event.getParams().get("baseurl"), contextParams, threader);
                }
            }
        }
        catch (MailException me) {
            throw me;
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new MailException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String getSenderFrom(IssueEvent event, Map<String, Object> contextParams) {
        String email;
        String name;
        String from = ManagerFactory.getApplicationProperties().getDefaultBackedString("jira.email.fromheader.format");
        if (from == null) {
            return null;
        }
        User user = event.getUser();
        if (Users.isAnonymous(user)) {
            name = "Anonymous";
        } else {
            try {
                String fullName = user.getDisplayName();
                name = org.apache.commons.lang.StringUtils.isBlank((String)fullName) ? user.getName() : fullName;
            }
            catch (Exception exception) {
                try {
                    name = user.getName();
                }
                catch (Exception exception2) {
                    name = "";
                }
            }
        }
        try {
            email = user != null ? user.getEmailAddress() : "";
        }
        catch (Exception exception) {
            email = "";
        }
        String hostname = user != null && email != null ? email.substring(email.indexOf("@") + 1) : "";
        from = StringUtils.replaceAll((String)from, (String)"${fullname}", (String)name);
        from = StringUtils.replaceAll((String)from, (String)"${email}", (String)email);
        from = StringUtils.replaceAll((String)from, (String)"${email.hostname}", (String)hostname);
        return from;
    }

    public String toString() {
        Issue issue = this.event.getIssue();
        String issueString = new ToStringBuilder((Object)issue).append("id", (Object)issue.getId()).append("summary", (Object)issue.getSummary()).append("key", (Object)issue.getKey()).append("created", (Object)issue.getCreated()).append("updated", (Object)issue.getUpdated()).append("assignee", (Object)issue.getAssignee()).append("reporter", (Object)issue.getReporter()).toString();
        return new ToStringBuilder((Object)this).append("issue", (Object)issueString).append("remoteUser", (Object)this.event.getUser()).append("notificationType", (Object)this.notificationType).append("eventTypeId", this.event.getEventTypeId().longValue()).append("templateId", this.templateId.longValue()).toString();
    }

    protected Map<String, Object> getIssueContextParams(IssueEvent iEvent) throws GenericEntityException {
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        TemplateContext templateContext = this.templateContextFactory.getTemplateContext(iEvent);
        contextParams.putAll(templateContext.getTemplateParams());
        return JiraMailQueueUtils.getContextParamsBody(contextParams);
    }

    public Set getRecipientList() {
        return this.recipientList;
    }
}

