/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.text.NumberFormat;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class LicenseJohnsonEventRaiserImpl
implements LicenseJohnsonEventRaiser {
    private static final Logger log = Logger.getLogger(LicenseJohnsonEventRaiserImpl.class);
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraLicenseService jiraLicenseService;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final UserUtil userUtil;
    private static final int V1 = 1;

    public LicenseJohnsonEventRaiserImpl(BuildUtilsInfo buildUtilsInfo, JiraLicenseService jiraLicenseService, I18nHelper.BeanFactory i18nBeanFactory, UserUtil userUtil) {
        this.i18nBeanFactory = Assertions.notNull("i18nBeanFactory", i18nBeanFactory);
        this.jiraLicenseService = Assertions.notNull("jiraLicenseService", jiraLicenseService);
        this.buildUtilsInfo = Assertions.notNull("buildUtilsInfo", buildUtilsInfo);
        this.userUtil = Assertions.notNull("userUtil", userUtil);
    }

    @Override
    public boolean checkLicenseIsTooOldForBuild(ServletContext servletContext, LicenseDetails licenseDetails) {
        boolean shouldRaiseEvent;
        boolean bl = shouldRaiseEvent = licenseDetails.isLicenseSet() && licenseDetails.getLicenseVersion() > 1 && !licenseDetails.isMaintenanceValidForBuildDate(this.buildUtilsInfo.getCurrentBuildDate()) && !licenseDetails.hasLicenseTooOldForBuildConfirmationBeenDone();
        if (shouldRaiseEvent) {
            log.error((Object)("The current license is too old (" + licenseDetails.getMaintenanceEndString(new OutlookDate(Locale.getDefault())) + ") to run this version (" + this.buildUtilsInfo.getVersion() + " - " + this.buildUtilsInfo.getCurrentBuildDate() + ") of JIRA."));
            JohnsonEventContainer cont = JohnsonEventContainer.get((ServletContext)servletContext);
            Event newEvent = new Event(EventType.get((String)"license-too-old"), "The current license is too old to install this version of JIRA (" + this.buildUtilsInfo.getVersion() + ")", EventLevel.get((String)"error"));
            cont.addEvent(newEvent);
        }
        return shouldRaiseEvent;
    }

    @Override
    public boolean checkLicenseIsInvalid(ServletContext servletContext, LicenseDetails licenseDetails) {
        I18nHelper i18nHelper = this.i18nBeanFactory.getInstance((User)null);
        JiraLicenseService.ValidationResult validationResult = this.jiraLicenseService.validate(i18nHelper, licenseDetails.getLicenseString());
        if (validationResult.getErrorCollection().hasAnyErrors()) {
            StringBuilder messages = new StringBuilder();
            if (validationResult.getLicenseVersion() == 1) {
                NumberFormat nf = NumberFormat.getNumberInstance();
                messages.append(i18nHelper.getText("setup.error.invalidlicensekey.wrong.license.version.johnson", nf.format(validationResult.getTotalUserCount()), nf.format(validationResult.getActiveUserCount())));
            } else {
                for (String msg : validationResult.getErrorCollection().getErrors().values()) {
                    log.error((Object)msg);
                    messages.append((Object)msg).append("\n");
                }
            }
            JohnsonEventContainer cont = JohnsonEventContainer.get((ServletContext)servletContext);
            Event newEvent = new Event(EventType.get((String)"license-invalid"), messages.toString(), EventLevel.get((String)"error"));
            cont.addEvent(newEvent);
            return true;
        }
        return false;
    }
}

