/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.LicenseManager;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.license.DefaultLicenseDetails;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.JiraLicenseStore;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.NewLicenseEvent;
import com.atlassian.jira.license.NullLicenseDetails;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.license.SIDManager;
import org.apache.log4j.Logger;

public class JiraLicenseManagerImpl
implements JiraLicenseManager {
    private final Logger log = Logger.getLogger(this.getClass());
    private final JiraLicenseStore licenseStore;
    private final BuildUtilsInfo buildUtilsInfo;
    private final LicenseManager licenseManager;
    private final SIDManager sidManager;
    private final ApplicationProperties applicationProperties;
    private final ExternalLinkUtil externalLinkUtil;
    private final DateTimeFormatter dateTimeFormatter;
    private final I18nHelper.BeanFactory i18nFactory;
    private final EventPublisher eventPublisher;

    public JiraLicenseManagerImpl(JiraLicenseStore licenseStore, BuildUtilsInfo buildUtilsInfo, LicenseManager licenseManager, ApplicationProperties applicationProperties, ExternalLinkUtil externalLinkUtil, SIDManager sidManager, DateTimeFormatter dateTimeFormatter, I18nHelper.BeanFactory i18nFactory, EventPublisher eventPublisher) {
        this.dateTimeFormatter = dateTimeFormatter;
        this.i18nFactory = i18nFactory;
        this.eventPublisher = eventPublisher;
        this.licenseStore = Assertions.notNull("licenseStore", licenseStore);
        this.buildUtilsInfo = Assertions.notNull("buildUtilsInfo", buildUtilsInfo);
        this.licenseManager = Assertions.notNull("licenseManager", licenseManager);
        this.externalLinkUtil = Assertions.notNull("externalLinkUtil", externalLinkUtil);
        this.applicationProperties = Assertions.notNull("applicationProperties", applicationProperties);
        this.sidManager = Assertions.notNull("sidManager", sidManager);
    }

    @Override
    public String getServerId() {
        String serverId = this.licenseStore.retrieveServerId();
        if (StringUtils.isBlank((String)serverId)) {
            serverId = this.sidManager.generateSID();
            this.licenseStore.storeServerId(serverId);
        }
        return serverId;
    }

    @Override
    public LicenseDetails getLicense() {
        return this.getLicense(this.licenseStore.retrieve());
    }

    @Override
    public LicenseDetails getLicense(String licenseString) {
        JiraLicense jiraLicense = this.getLicenseInternal(licenseString);
        return jiraLicense == null ? NullLicenseDetails.NULL_LICENSE_DETAILS : new DefaultLicenseDetails(jiraLicense, licenseString, this.applicationProperties, this.externalLinkUtil, this.buildUtilsInfo, this.i18nFactory, this.dateTimeFormatter);
    }

    @Override
    public boolean isDecodeable(String licenseString) {
        try {
            return this.getLicenseInternal(licenseString) != null;
        }
        catch (LicenseException e) {
            return false;
        }
    }

    @Override
    public LicenseDetails setLicense(String licenseString) {
        if (!this.isDecodeable(licenseString)) {
            throw new IllegalArgumentException("The licenseString is invalid and will not be stored.");
        }
        this.licenseStore.store(licenseString);
        LicenseDetails licenseDetails = this.getLicense(licenseString);
        if (licenseDetails.isMaintenanceValidForBuildDate(this.buildUtilsInfo.getCurrentBuildDate()) && licenseDetails.hasLicenseTooOldForBuildConfirmationBeenDone()) {
            this.licenseStore.resetOldBuildConfirmation();
        }
        this.eventPublisher.publish((Object)new NewLicenseEvent(licenseDetails));
        return licenseDetails;
    }

    @Override
    public void confirmProceedUnderEvaluationTerms(String userName) {
        this.licenseStore.confirmProceedUnderEvaluationTerms(userName);
    }

    private JiraLicense getLicenseInternal(String licenseString) {
        if (StringUtils.isBlank((String)licenseString)) {
            return null;
        }
        return (JiraLicense)this.licenseManager.getLicense(licenseString).getProductLicense(Product.JIRA);
    }
}

