/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.comparator.LocaleSensitiveGenericValueComparator;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class SecurityLevelClauseValuesGenerator
implements ClauseValuesGenerator {
    private final IssueSecurityLevelManager issueSecurityLevelManager;

    public SecurityLevelClauseValuesGenerator(IssueSecurityLevelManager issueSecurityLevelManager) {
        this.issueSecurityLevelManager = issueSecurityLevelManager;
    }

    @Override
    public ClauseValuesGenerator.Results getPossibleValues(User searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        List<GenericValue> securityLevels = this.getRelevantSecurityLevels(searcher);
        Collections.sort(securityLevels, new LocaleSensitiveGenericValueComparator(this.getLocale(searcher), "name"));
        LinkedHashSet<ClauseValuesGenerator.Result> results = new LinkedHashSet<ClauseValuesGenerator.Result>();
        for (GenericValue securityLevel : securityLevels) {
            if (results.size() == maxNumResults) break;
            String levelName = securityLevel.getString("name");
            String lowerCaseLevelName = levelName.toLowerCase();
            if (!StringUtils.isBlank((String)valuePrefix) && !lowerCaseLevelName.startsWith(valuePrefix.toLowerCase())) continue;
            results.add(new ClauseValuesGenerator.Result(levelName));
        }
        return new ClauseValuesGenerator.Results(new ArrayList<ClauseValuesGenerator.Result>(results));
    }

    List<GenericValue> getRelevantSecurityLevels(User searcher) {
        List<Object> securityLevels;
        try {
            Collection<GenericValue> secGvs = this.issueSecurityLevelManager.getAllUsersSecurityLevels(searcher);
            securityLevels = secGvs != null ? new ArrayList<GenericValue>(secGvs) : Collections.emptyList();
        }
        catch (GenericEntityException e) {
            securityLevels = Collections.emptyList();
        }
        return securityLevels;
    }

    Locale getLocale(User searcher) {
        return new I18nBean(searcher).getLocale();
    }
}

