/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.sharing.search.SharedEntitySearchContext;
import com.atlassian.jira.sharing.search.SharedEntitySearchParametersBuilder;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SavedFilterValuesGenerator
implements ClauseValuesGenerator {
    private final SearchRequestService searchRequestService;

    public SavedFilterValuesGenerator(SearchRequestService searchRequestService) {
        this.searchRequestService = searchRequestService;
    }

    @Override
    public ClauseValuesGenerator.Results getPossibleValues(User searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ArrayList<ClauseValuesGenerator.Result> savedFilterValues = new ArrayList<ClauseValuesGenerator.Result>();
        SharedEntitySearchParametersBuilder builder = new SharedEntitySearchParametersBuilder().setName(StringUtils.isBlank((String)valuePrefix) ? "" : valuePrefix).setEntitySearchContext(SharedEntitySearchContext.USE);
        SharedEntitySearchResult<SearchRequest> sharedEntitySearchResult = this.searchRequestService.search(new JiraServiceContextImpl(searcher), builder.toSearchParameters(), 0, maxNumResults);
        List<SearchRequest> searchRequests = sharedEntitySearchResult.getResults();
        for (SearchRequest searchRequest : searchRequests) {
            if (savedFilterValues.size() == maxNumResults) break;
            savedFilterValues.add(new ClauseValuesGenerator.Result(searchRequest.getName()));
        }
        return new ClauseValuesGenerator.Results(savedFilterValues);
    }
}

