/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.comparator.LocaleSensitiveGenericValueComparator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class ProjectCategoryClauseValuesGenerator
implements ClauseValuesGenerator {
    private final ProjectManager projectManager;

    public ProjectCategoryClauseValuesGenerator(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public ClauseValuesGenerator.Results getPossibleValues(User searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ArrayList<GenericValue> projectCategories = new ArrayList<GenericValue>(this.projectManager.getProjectCategories());
        Collections.sort(projectCategories, new LocaleSensitiveGenericValueComparator(this.getLocale(searcher), "name"));
        ArrayList<ClauseValuesGenerator.Result> results = new ArrayList<ClauseValuesGenerator.Result>();
        for (GenericValue projectCategoryGv : projectCategories) {
            if (results.size() == maxNumResults) break;
            String categoryName = projectCategoryGv.getString("name");
            String lowerCaseCategoryName = categoryName.toLowerCase();
            if (!StringUtils.isBlank((String)valuePrefix) && !lowerCaseCategoryName.startsWith(valuePrefix.toLowerCase())) continue;
            results.add(new ClauseValuesGenerator.Result(categoryName));
        }
        return new ClauseValuesGenerator.Results(results);
    }

    Locale getLocale(User searcher) {
        return new I18nBean(searcher).getLocale();
    }
}

