/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.security.groups.GroupManager;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class GroupValuesGenerator
implements ClauseValuesGenerator {
    private final GroupManager groupManager;

    public GroupValuesGenerator(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    @Override
    public ClauseValuesGenerator.Results getPossibleValues(User searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        Collection<Group> groups = this.getAllGroups();
        ArrayList<ClauseValuesGenerator.Result> groupValues = new ArrayList<ClauseValuesGenerator.Result>();
        for (Group group : groups) {
            if (groupValues.size() == maxNumResults) break;
            String lowerCaseGroupName = group.getName().toLowerCase();
            if (!StringUtils.isBlank((String)valuePrefix) && !lowerCaseGroupName.startsWith(valuePrefix.toLowerCase())) continue;
            groupValues.add(new ClauseValuesGenerator.Result(group.getName()));
        }
        return new ClauseValuesGenerator.Results(groupValues);
    }

    protected Collection<Group> getAllGroups() {
        return this.groupManager.getAllGroups();
    }
}

