/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.comparator.LocaleSensitiveStringComparator;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class CustomFieldOptionsClauseValuesGenerator
implements ClauseValuesGenerator {
    private final CustomFieldManager customFieldManager;
    private final SearchHandlerManager searchHandlerManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final PermissionManager permissionManager;

    public CustomFieldOptionsClauseValuesGenerator(CustomFieldManager customFieldManager, SearchHandlerManager searchHandlerManager, FieldConfigSchemeManager fieldConfigSchemeManager, PermissionManager permissionManager) {
        this.customFieldManager = customFieldManager;
        this.searchHandlerManager = searchHandlerManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public ClauseValuesGenerator.Results getPossibleValues(User searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        LinkedHashSet<String> optionValues = new LinkedHashSet<String>();
        Collection<String> fieldIds = this.searchHandlerManager.getFieldIds(searcher, jqlClauseName);
        if (!fieldIds.isEmpty()) {
            Collection<Project> visibleProjects = this.permissionManager.getProjectObjects(10, searcher);
            for (String fieldId : fieldIds) {
                CustomField customField = this.customFieldManager.getCustomFieldObject(fieldId);
                if (customField == null) continue;
                List<JiraContextNode> contexts = this.getContextsForCustomField(customField);
                for (JiraContextNode context : contexts) {
                    Options options;
                    Project contextProject = context.getProjectObject();
                    if (contextProject != null && !visibleProjects.contains(contextProject) || (options = customField.getOptions(null, context)) == null) continue;
                    for (Option option : options) {
                        String lowerCaseOptionVal = option.toString().toLowerCase();
                        if (!StringUtils.isBlank((String)valuePrefix) && !lowerCaseOptionVal.startsWith(valuePrefix.toLowerCase())) continue;
                        optionValues.add(option.toString());
                    }
                }
            }
        }
        ArrayList orderedValues = new ArrayList(optionValues);
        Collections.sort(orderedValues, new LocaleSensitiveStringComparator(this.getLocale(searcher)));
        ArrayList<ClauseValuesGenerator.Result> results = new ArrayList<ClauseValuesGenerator.Result>();
        for (String orderedValue : orderedValues) {
            if (results.size() == maxNumResults) break;
            results.add(new ClauseValuesGenerator.Result(orderedValue));
        }
        return new ClauseValuesGenerator.Results(results);
    }

    List<JiraContextNode> getContextsForCustomField(CustomField customField) {
        ArrayList<JiraContextNode> contextNodes = new ArrayList<JiraContextNode>();
        List<FieldConfigScheme> configSchemes = this.fieldConfigSchemeManager.getConfigSchemesForField(customField);
        for (FieldConfigScheme configScheme : configSchemes) {
            List<JiraContextNode> contexts = configScheme.getContexts();
            if (contexts == null) continue;
            contextNodes.addAll(contexts);
        }
        if (contextNodes.isEmpty()) {
            contextNodes.add(this.getRootContext());
        }
        return contextNodes;
    }

    JiraContextNode getRootContext() {
        return JiraContextTreeManager.getRootContext();
    }

    Locale getLocale(User searcher) {
        return new I18nBean(searcher).getLocale();
    }
}

