/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IssueConstantInfoResolver;
import com.atlassian.jira.jql.resolver.StatusResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.RawValuesExistValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;

public class StatusValidator
implements ClauseValidator {
    private final RawValuesExistValidator rawValuesExistValidator;
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final I18nHelper.BeanFactory beanFactory;

    public StatusValidator(StatusResolver statusResolver, JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.rawValuesExistValidator = this.getRawValuesValidator(statusResolver, operandResolver);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
    }

    @Override
    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        MessageSet messageSet = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!messageSet.hasAnyErrors()) {
            messageSet.addMessageSet(this.rawValuesExistValidator.validate(searcher, terminalClause));
        }
        return messageSet;
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY);
    }

    RawValuesExistValidator getRawValuesValidator(StatusResolver statusResolver, JqlOperandResolver operandResolver) {
        return new RawValuesExistValidator(operandResolver, new IssueConstantInfoResolver<Status>(statusResolver), this.beanFactory);
    }
}

