/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.List;

public class SelectCustomFieldValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final CustomField customField;
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;
    private final JqlOperandResolver jqlOperandResolver;
    private final I18nHelper.BeanFactory beanFactory;

    public SelectCustomFieldValidator(CustomField customField, JqlSelectOptionsUtil jqlSelectOptionsUtil, JqlOperandResolver jqlOperandResolver, I18nHelper.BeanFactory beanFactory) {
        this.beanFactory = Assertions.notNull("beanFactory", beanFactory);
        this.customField = Assertions.notNull("customField", customField);
        this.jqlSelectOptionsUtil = Assertions.notNull("jqlSelectOptionsUtil", jqlSelectOptionsUtil);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
    }

    @Override
    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        MessageSet messageSet = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!messageSet.hasAnyMessages()) {
            return this.validateValues(searcher, terminalClause);
        }
        return messageSet;
    }

    private MessageSet validateValues(User searcher, TerminalClause terminalClause) {
        I18nHelper i18n = this.getI18n(searcher);
        MessageSetImpl messageSet = new MessageSetImpl();
        Operand operand = terminalClause.getOperand();
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, operand, terminalClause);
        if (literals == null || literals.isEmpty()) {
            return messageSet;
        }
        for (QueryLiteral literal : literals) {
            List<Option> options;
            if (literal.isEmpty() || !(options = this.getOptionsFromLiteral(searcher, literal)).isEmpty()) continue;
            if (this.jqlOperandResolver.isFunctionOperand(literal.getSourceOperand())) {
                messageSet.addErrorMessage(i18n.getText("jira.jql.clause.select.option.does.not.exist.function", literal.getSourceOperand().getName(), terminalClause.getName()));
                continue;
            }
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.select.option.does.not.exist", literal.asString(), terminalClause.getName()));
        }
        return messageSet;
    }

    protected List<Option> getOptionsFromLiteral(User searcher, QueryLiteral literal) {
        return this.jqlSelectOptionsUtil.getOptions(this.customField, searcher, literal, false);
    }

    I18nHelper getI18n(User user) {
        return this.beanFactory.getInstance(user);
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY);
    }
}

