/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.jql.resolver.SavedFilterResolver;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import java.util.List;

@InjectableComponent
public class SavedFilterCycleDetector {
    private final SavedFilterResolver savedFilterResolver;
    private final JqlOperandResolver jqlOperandResolver;

    public SavedFilterCycleDetector(SavedFilterResolver savedFilterResolver, JqlOperandResolver jqlOperandResolver) {
        this.savedFilterResolver = Assertions.notNull("savedFilterResolver", savedFilterResolver);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
    }

    public boolean containsSavedFilterReference(User searcher, boolean overrideSecurity, SearchRequest savedFilter, Long filterId) {
        Assertions.notNull("savedFilter", savedFilter);
        Query savedFilterQuery = savedFilter.getQuery();
        if (filterId == null) {
            filterId = savedFilter.getId();
        }
        return this.containsFilterRef(searcher, overrideSecurity, filterId, savedFilterQuery.getWhereClause());
    }

    private boolean containsFilterRef(User searcher, boolean overrideSecurity, Long filterId, Clause filterClause) {
        if (filterClause == null) {
            return false;
        }
        NamedTerminalClauseCollectingVisitor collectingVisitor = new NamedTerminalClauseCollectingVisitor(SystemSearchConstants.forSavedFilter().getJqlClauseNames().getJqlFieldNames());
        filterClause.accept(collectingVisitor);
        List<TerminalClause> nestedFilterClauses = collectingVisitor.getNamedClauses();
        QueryCreationContextImpl creationContext = new QueryCreationContextImpl(searcher, overrideSecurity);
        for (TerminalClause nestedFilterClause : nestedFilterClauses) {
            List<QueryLiteral> filterValues = this.jqlOperandResolver.getValues(creationContext, nestedFilterClause.getOperand(), nestedFilterClause);
            List<SearchRequest> matchingSearchRequests = overrideSecurity ? this.savedFilterResolver.getSearchRequestOverrideSecurity(filterValues) : this.savedFilterResolver.getSearchRequest(searcher, filterValues);
            for (SearchRequest matchingSearchRequest : matchingSearchRequests) {
                if (filterId.equals(matchingSearchRequest.getId())) {
                    return true;
                }
                Query query = matchingSearchRequest.getQuery();
                if (!this.containsFilterRef(searcher, overrideSecurity, filterId, query.getWhereClause())) continue;
                return true;
            }
        }
        return false;
    }
}

