/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.ResolutionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.ResolutionResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.RawValuesExistValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;

public class ResolutionValidator
implements ClauseValidator {
    private final RawValuesExistValidator rawValuesExistValidator;
    private final SupportedOperatorsValidator supportedOperatorsValidator;

    public ResolutionValidator(ResolutionResolver resolutionResolver, JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory) {
        this.rawValuesExistValidator = new RawValuesExistValidator(operandResolver, new ResolutionIndexInfoResolver(resolutionResolver), beanFactory);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
    }

    @Override
    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        MessageSet messageSet = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!messageSet.hasAnyErrors()) {
            messageSet.addMessageSet(this.rawValuesExistValidator.validate(searcher, terminalClause));
        }
        return messageSet;
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, OperatorClasses.RELATIONAL_ONLY_OPERATORS);
    }
}

