/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.ProjectIndexInfoResolver;
import com.atlassian.jira.jql.validator.ValuesExistValidator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

class ProjectValuesExistValidator
extends ValuesExistValidator {
    private final ProjectIndexInfoResolver projectIndexInfoResolver;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;

    ProjectValuesExistValidator(JqlOperandResolver operandResolver, ProjectIndexInfoResolver projectIndexInfoResolver, PermissionManager permissionManager, ProjectManager projectManager, I18nHelper.BeanFactory beanFactory) {
        super(operandResolver, beanFactory);
        this.projectIndexInfoResolver = Assertions.notNull("projectIndexInfoResolver", projectIndexInfoResolver);
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.projectManager = Assertions.notNull("projectManager", projectManager);
    }

    @Override
    boolean stringValueExists(User searcher, String value) {
        List<String> ids = this.projectIndexInfoResolver.getIndexedValues(value);
        return this.projectExists(searcher, ids);
    }

    @Override
    boolean longValueExist(User searcher, Long value) {
        List<String> ids = this.projectIndexInfoResolver.getIndexedValues(value);
        return this.projectExists(searcher, ids);
    }

    boolean projectExists(User searcher, List<String> ids) {
        for (String sid : ids) {
            Project project;
            Long id = this.convertToLong(sid);
            if (id == null || (project = this.projectManager.getProjectObj(id)) == null || !this.permissionManager.hasPermission(10, project, searcher)) continue;
            return true;
        }
        return false;
    }

    private Long convertToLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

