/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlDurationSupport;
import com.atlassian.jira.jql.util.JqlDurationSupportImpl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.List;

class PositiveDurationValueValidator {
    private final JqlOperandResolver operandResolver;
    private final JqlDurationSupport jqlDurationSupport;

    PositiveDurationValueValidator(JqlOperandResolver operandResolver) {
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.jqlDurationSupport = new JqlDurationSupportImpl();
    }

    MessageSet validate(User searcher, TerminalClause terminalClause) {
        Assertions.notNull("terminalClause", terminalClause);
        Operand operand = terminalClause.getOperand();
        MessageSetImpl messages = new MessageSetImpl();
        if (this.operandResolver.isValidOperand(operand)) {
            I18nHelper i18n = this.getI18n(searcher);
            List<QueryLiteral> values = this.operandResolver.getValues(searcher, operand, terminalClause);
            String fieldName = terminalClause.getName();
            for (QueryLiteral value : values) {
                boolean isValid = true;
                Long longValue = value.getLongValue();
                if (longValue != null) {
                    isValid = longValue >= 0L;
                } else {
                    String str = value.getStringValue();
                    if (str != null) {
                        isValid = this.jqlDurationSupport.validate(str, false);
                    }
                }
                if (isValid) continue;
                String msg = this.operandResolver.isFunctionOperand(value.getSourceOperand()) ? i18n.getText("jira.jql.clause.positive.duration.format.invalid.from.func", value.getSourceOperand().getName(), fieldName) : i18n.getText("jira.jql.clause.positive.duration.format.invalid", value.toString(), fieldName);
                messages.addErrorMessage(msg);
            }
        }
        return messages;
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }
}

