/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlIssueKeySupport;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.List;

@InjectableComponent
public class IssueIdValidator
implements ClauseValidator {
    private final JqlOperandResolver operandResolver;
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final JqlIssueKeySupport issueKeySupport;
    private final JqlIssueSupport issueSupport;
    private final I18nHelper.BeanFactory i18nFactory;

    IssueIdValidator(JqlOperandResolver operandResolver, JqlIssueKeySupport issueKeySupport, JqlIssueSupport issueSupport, I18nHelper.BeanFactory i18nFactory, SupportedOperatorsValidator supportedOperatorsValidator) {
        this.issueSupport = issueSupport;
        this.issueKeySupport = Assertions.notNull("issueKeySupport", issueKeySupport);
        this.i18nFactory = Assertions.notNull("i18nFactory", i18nFactory);
        this.supportedOperatorsValidator = Assertions.notNull("supportedOperatorsValidator", supportedOperatorsValidator);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
    }

    public IssueIdValidator(JqlOperandResolver operandResolver, JqlIssueKeySupport issueKeySupport, JqlIssueSupport issueSupport, I18nHelper.BeanFactory i18nFactory) {
        this(operandResolver, issueKeySupport, issueSupport, i18nFactory, new SupportedOperatorsValidator(OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, OperatorClasses.RELATIONAL_ONLY_OPERATORS));
    }

    @Override
    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        Operand operand;
        List<QueryLiteral> values;
        Assertions.notNull("terminalClause", terminalClause);
        MessageSet messages = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!messages.hasAnyErrors() && (values = this.operandResolver.getValues(searcher, operand = terminalClause.getOperand(), terminalClause)) != null) {
            for (QueryLiteral value : values) {
                if (value.getLongValue() != null) {
                    this.validateIssueId(messages, value.getLongValue(), searcher, terminalClause, value.getSourceOperand());
                    continue;
                }
                if (value.getStringValue() == null) continue;
                this.validateIssueKey(messages, value.getStringValue(), searcher, terminalClause, value.getSourceOperand());
            }
        }
        return messages;
    }

    private boolean validateIssueId(MessageSet messages, Long issueId, User searcher, TerminalClause clause, Operand operand) {
        Issue issue = this.issueSupport.getIssue(issueId, searcher);
        if (issue == null) {
            I18nHelper i18n = this.i18nFactory.getInstance(searcher);
            if (!this.operandResolver.isFunctionOperand(operand)) {
                messages.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.id", clause.getName(), issueId.toString()));
            } else {
                messages.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.name.from.function", operand.getName(), clause.getName()));
            }
            return false;
        }
        return true;
    }

    private boolean validateIssueKey(MessageSet messages, String key, User searcher, TerminalClause clause, Operand operand) {
        List<Issue> issues = this.issueSupport.getIssues(key, searcher);
        if (issues.isEmpty()) {
            I18nHelper i18n = this.i18nFactory.getInstance(searcher);
            boolean validIssueKey = this.issueKeySupport.isValidIssueKey(key);
            if (!this.operandResolver.isFunctionOperand(operand)) {
                if (validIssueKey) {
                    messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.noissue", key, clause.getName()));
                } else {
                    messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.invalidissuekey", key, clause.getName()));
                }
            } else if (validIssueKey) {
                messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.noissue.from.func", operand.getName(), clause.getName()));
            } else {
                messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.invalidissuekey.from.func", operand.getName(), clause.getName()));
            }
            return false;
        }
        return true;
    }
}

