/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.validator.ChangedClauseValidator;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.ValidatorRegistry;
import com.atlassian.jira.jql.validator.WasClauseValidator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class DefaultValidatorRegistry
implements ValidatorRegistry {
    private final SearchHandlerManager manager;
    private final List<ClauseValidator> wasClauseValidators = new ArrayList<ClauseValidator>();
    private final ChangedClauseValidator changedClauseValidator;

    public DefaultValidatorRegistry(SearchHandlerManager manager, WasClauseValidator wasClauseValidator, ChangedClauseValidator changedClauseValidator) {
        this.manager = Assertions.notNull("manager", manager);
        this.wasClauseValidators.add(Assertions.notNull("wasClauseValidator", wasClauseValidator));
        this.changedClauseValidator = Assertions.notNull("changedClauseValidator", changedClauseValidator);
    }

    @Override
    public Collection<ClauseValidator> getClauseValidator(User searcher, TerminalClause clause) {
        Assertions.notNull("clause", clause);
        Collection<ClauseHandler> clauseHandlers = this.manager.getClauseHandler(searcher, clause.getName());
        ArrayList<ClauseValidator> clauseValidators = new ArrayList<ClauseValidator>(clauseHandlers.size());
        for (ClauseHandler clauseHandler : clauseHandlers) {
            clauseValidators.add(clauseHandler.getValidator());
        }
        return clauseValidators;
    }

    @Override
    public Collection<ClauseValidator> getClauseValidator(User searcher, WasClause clause) {
        return Collections.unmodifiableCollection(this.wasClauseValidators);
    }

    @Override
    public ChangedClauseValidator getClauseValidator(User searcher, ChangedClause clause) {
        return this.changedClauseValidator;
    }
}

