/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;

public class DefaultOperatorUsageValidator
implements OperatorUsageValidator {
    private final JqlOperandResolver operandResolver;
    private final I18nHelper.BeanFactory factory;

    public DefaultOperatorUsageValidator(JqlOperandResolver operandResolver, I18nHelper.BeanFactory factory) {
        this.factory = Assertions.notNull("factory", factory);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
    }

    @Override
    public boolean check(User user, TerminalClause clause) {
        return this.validate(user, clause, null);
    }

    @Override
    public MessageSet validate(User searcher, TerminalClause clause) {
        MessageSetImpl messages = new MessageSetImpl();
        this.validate(searcher, clause, messages);
        return messages;
    }

    private boolean validate(User user, TerminalClause clause, MessageSet set) {
        boolean valid = true;
        Operand operand = clause.getOperand();
        if (this.operandResolver.isValidOperand(operand)) {
            Operator operator = clause.getOperator();
            boolean isList = this.operandResolver.isListOperand(operand);
            if (isList) {
                if (!OperatorClasses.LIST_ONLY_OPERATORS.contains((Object)operator)) {
                    valid = false;
                    this.addError(user, set, "jira.jql.operator.usage.not.support.list", operator.getDisplayString(), operand.getDisplayString(), clause.getName());
                }
            } else if (OperatorClasses.LIST_ONLY_OPERATORS.contains((Object)operator)) {
                valid = false;
                this.addError(user, set, "jira.jql.operator.usage.not.support.non.list", operator.getDisplayString(), operand.getDisplayString(), clause.getName());
            }
            if (this.operandResolver.isEmptyOperand(operand)) {
                if (!OperatorClasses.EMPTY_OPERATORS.contains((Object)operator)) {
                    valid = false;
                    this.addError(user, set, "jira.jql.operator.usage.not.support.empty", operator.getDisplayString(), operand.getDisplayString(), clause.getName());
                }
            } else if (OperatorClasses.EMPTY_ONLY_OPERATORS.contains((Object)operator)) {
                valid = false;
                this.addError(user, set, "jira.jql.operator.usage.is.only.supports.empty", operator.getDisplayString(), clause.getName());
            }
        }
        return valid;
    }

    private void addError(User searcher, MessageSet messageset, String key, Object ... values) {
        if (messageset != null) {
            I18nHelper i18n = this.factory.getInstance(searcher);
            messageset.addErrorMessage(i18n.getText(key, values));
        }
    }
}

