/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.ComponentIndexInfoResolver;
import com.atlassian.jira.jql.validator.ValuesExistValidator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

class ComponentValuesExistValidator
extends ValuesExistValidator {
    private final ComponentIndexInfoResolver componentIndexInfoResolver;
    private final PermissionManager permissionManager;
    private final ProjectComponentManager projectComponentManager;
    private final ProjectManager projectManager;

    ComponentValuesExistValidator(JqlOperandResolver operandResolver, ComponentIndexInfoResolver componentIndexInfoResolver, PermissionManager permissionManager, ProjectComponentManager projectComponentManager, ProjectManager projectManager, I18nHelper.BeanFactory beanFactory) {
        super(operandResolver, beanFactory);
        this.componentIndexInfoResolver = Assertions.notNull("componentIndexInfoResolver", componentIndexInfoResolver);
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.projectComponentManager = Assertions.notNull("projectComponentManager", projectComponentManager);
        this.projectManager = Assertions.notNull("projectManager", projectManager);
    }

    @Override
    boolean stringValueExists(User searcher, String value) {
        List<String> ids = this.componentIndexInfoResolver.getIndexedValues(value);
        return this.componentExists(searcher, ids);
    }

    @Override
    boolean longValueExist(User searcher, Long value) {
        List<String> ids = this.componentIndexInfoResolver.getIndexedValues(value);
        return this.componentExists(searcher, ids);
    }

    boolean componentExists(User searcher, List<String> ids) {
        for (String sid : ids) {
            Project project;
            Long id = this.convertToLong(sid);
            if (id == null || (project = this.getComponentsProject(id)) == null || !this.permissionManager.hasPermission(10, project, searcher)) continue;
            return true;
        }
        return false;
    }

    private Project getComponentsProject(Long componentId) {
        ProjectComponent component;
        try {
            component = this.projectComponentManager.find(componentId);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
        return this.projectManager.getProjectObj(component.getProjectId());
    }

    private Long convertToLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

