/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SelectCustomFieldValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.List;

@NonInjectableComponent
public class CascadingSelectCustomFieldValidator
extends SelectCustomFieldValidator
implements ClauseValidator {
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;
    private final CustomField customField;

    public CascadingSelectCustomFieldValidator(CustomField customField, JqlSelectOptionsUtil jqlSelectOptionsUtil, JqlOperandResolver jqlOperandResolver, I18nHelper.BeanFactory beanFactory) {
        super(customField, jqlSelectOptionsUtil, jqlOperandResolver, beanFactory);
        this.customField = Assertions.notNull("customField", customField);
        this.jqlSelectOptionsUtil = Assertions.notNull("jqlSelectOptionsUtil", jqlSelectOptionsUtil);
    }

    @Override
    protected List<Option> getOptionsFromLiteral(User searcher, QueryLiteral literal) {
        ArrayList<Option> options = new ArrayList<Option>();
        options.addAll(this.jqlSelectOptionsUtil.getOptions(this.customField, searcher, literal, true));
        if (literal.getLongValue() != null && literal.getLongValue() < 0L) {
            options.addAll(this.jqlSelectOptionsUtil.getOptions(this.customField, searcher, new QueryLiteral(literal.getSourceOperand(), -literal.getLongValue().longValue()), true));
        }
        return options;
    }
}

