/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.PositiveDurationValueValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;

abstract class AbstractTimeTrackingValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final PositiveDurationValueValidator positiveDurationValueValidator;
    private final ApplicationProperties applicationProperties;

    public AbstractTimeTrackingValidator(JqlOperandResolver operandResolver, ApplicationProperties applicationProperties) {
        Assertions.notNull("operandResolver", operandResolver);
        this.applicationProperties = Assertions.notNull("applicationProperties", applicationProperties);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
        this.positiveDurationValueValidator = this.getPositiveDurationValueValidator(operandResolver);
    }

    @Override
    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        if (this.applicationProperties.getOption("jira.option.timetracking")) {
            MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
            if (!errors.hasAnyErrors()) {
                errors = this.positiveDurationValueValidator.validate(searcher, terminalClause);
            }
            return errors;
        }
        MessageSetImpl messageSet = new MessageSetImpl();
        messageSet.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.timetracking.disabled", terminalClause.getName()));
        return messageSet;
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, OperatorClasses.RELATIONAL_ONLY_OPERATORS);
    }

    PositiveDurationValueValidator getPositiveDurationValueValidator(JqlOperandResolver operandResolver) {
        return new PositiveDurationValueValidator(operandResolver);
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }
}

