/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClausePrecedence;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.MultiClause;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.history.HistoryPredicate;
import com.atlassian.query.history.PredicateVisitor;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class ToJqlStringVisitor
implements OperandVisitor<String>,
ClauseVisitor<Result>,
PredicateVisitor<String> {
    private final JqlStringSupport support;

    ToJqlStringVisitor(JqlStringSupport support) {
        this.support = Assertions.notNull("support", support);
    }

    String toJqlString(Clause clause) {
        Assertions.notNull("clause", clause);
        return clause.accept(this).getJql();
    }

    @Override
    public String visit(EmptyOperand empty) {
        return "EMPTY";
    }

    @Override
    public String visit(FunctionOperand function) {
        StringBuilder sb = new StringBuilder(this.support.encodeFunctionName(function.getName()));
        sb.append("(");
        List<String> args = function.getArgs();
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(this.support.encodeFunctionArgument(arg));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String visit(MultiValueOperand multiValue) {
        StringBuilder sb = new StringBuilder("(");
        List<Operand> operands = multiValue.getValues();
        boolean first = true;
        for (Operand operand : operands) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(operand.accept(this));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String visit(SingleValueOperand singleValueOperand) {
        if (singleValueOperand.getLongValue() != null) {
            return singleValueOperand.getLongValue().toString();
        }
        return this.support.encodeStringValue(singleValueOperand.getStringValue());
    }

    @Override
    public Result visit(AndClause andClause) {
        return this.visitMultiClause(andClause, "AND", ClausePrecedence.AND);
    }

    @Override
    public Result visit(OrClause orClause) {
        return this.visitMultiClause(orClause, "OR", ClausePrecedence.OR);
    }

    @Override
    public Result visit(NotClause notClause) {
        Result subResult = notClause.getSubClause().accept(this);
        boolean brackets = subResult.getPrecedence().compareTo(ClausePrecedence.NOT) < 0;
        String jql = brackets ? String.format("%s (%s)", "NOT", subResult.getJql()) : String.format("%s %s", "NOT", subResult.getJql());
        return new Result(jql, ClausePrecedence.NOT);
    }

    @Override
    public Result visit(TerminalClause clause) {
        return this.buildJqlString(clause);
    }

    @Override
    public Result visit(WasClause clause) {
        return this.buildJqlString(clause);
    }

    @Override
    public Result visit(ChangedClause clause) {
        return this.buildJqlString(clause);
    }

    @Override
    public String visit(HistoryPredicate predicate) {
        return this.buildJqlString(predicate);
    }

    private Result visitMultiClause(MultiClause andClause, String clauseName, ClausePrecedence clausePrecedence) {
        StringBuilder sb = new StringBuilder();
        Iterator<Clause> clauseIterator = andClause.getClauses().iterator();
        while (clauseIterator.hasNext()) {
            boolean brackets;
            Clause clause = clauseIterator.next();
            Result clauseResult = clause.accept(this);
            boolean bl = brackets = clauseResult.getPrecedence().compareTo(clausePrecedence) < 0;
            if (brackets) {
                sb.append("(");
            }
            sb.append(clauseResult.getJql());
            if (brackets) {
                sb.append(")");
            }
            if (!clauseIterator.hasNext()) continue;
            sb.append(" ").append(clauseName).append(" ");
        }
        return new Result(sb.toString(), clausePrecedence);
    }

    private Result buildJqlString(TerminalClause clause) {
        HistoryPredicate predicate;
        StringBuilder builder = new StringBuilder(this.support.encodeFieldName(clause.getName()));
        builder.append(" ").append(clause.getOperator().getDisplayString());
        builder.append(" ").append(clause.getOperand().accept(this));
        if (clause instanceof WasClause && (predicate = ((WasClause)clause).getPredicate()) != null) {
            builder.append(" ").append(predicate.accept(this));
        }
        return new Result(builder.toString(), ClausePrecedence.TERMINAL);
    }

    private Result buildJqlString(ChangedClause clause) {
        StringBuilder builder = new StringBuilder(this.support.encodeFieldName(clause.getField()));
        builder.append(" ").append("changed");
        if (clause.getPredicate() != null) {
            builder.append(" ").append(clause.getPredicate().getDisplayString());
        }
        return new Result(builder.toString(), ClausePrecedence.TERMINAL);
    }

    private String buildJqlString(HistoryPredicate predicate) {
        StringBuilder builder = new StringBuilder(predicate.getDisplayString());
        return builder.toString();
    }

    public static final class Result {
        private final String jql;
        private final ClausePrecedence precedence;

        private Result(String jql, ClausePrecedence precedence) {
            this.jql = jql;
            this.precedence = precedence;
        }

        public String getJql() {
            return this.jql;
        }

        public ClausePrecedence getPrecedence() {
            return this.precedence;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

