/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.jql.util.ToJqlStringVisitor;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.SearchSort;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public final class JqlStringSupportImpl
implements JqlStringSupport {
    private static final Map<Character, Character> STRING_DECODE_MAPPING;
    private static final Map<Character, String> STRING_ENCODE_MAPPING;
    private static final char QUOTE_CHAR = '\"';
    private static final char SQUOTE_CHAR = '\'';
    public static final Set<String> RESERVED_WORDS;
    private final JqlQueryParser parser;

    public JqlStringSupportImpl(JqlQueryParser parser) {
        this.parser = Assertions.notNull("parser", parser);
    }

    @Override
    public Set<String> getJqlReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    public String encodeStringValue(String value) {
        Assertions.notNull("value", value);
        if (JqlStringSupportImpl.isLong(value) || !this.parser.isValidValue(value)) {
            return JqlStringSupportImpl.encodeAsQuotedString(value, false);
        }
        return value;
    }

    @Override
    public String encodeValue(String value) {
        Assertions.notNull("value", value);
        if (!this.parser.isValidValue(value)) {
            return JqlStringSupportImpl.encodeAsQuotedString(value, false);
        }
        return value;
    }

    @Override
    public String encodeFunctionArgument(String argument) {
        if (!this.parser.isValidFunctionArgument(argument)) {
            return JqlStringSupportImpl.encodeAsQuotedString(argument, true);
        }
        return argument;
    }

    @Override
    public String encodeFunctionName(String functionName) {
        if (!this.parser.isValidFunctionName(functionName)) {
            return JqlStringSupportImpl.encodeAsQuotedString(functionName, true);
        }
        return functionName;
    }

    @Override
    public String encodeFieldName(String fieldName) {
        if (!this.parser.isValidFieldName(fieldName)) {
            return JqlStringSupportImpl.encodeAsQuotedString(fieldName, true);
        }
        return fieldName;
    }

    @Override
    public String generateJqlString(Query query) {
        Assertions.notNull("query", query);
        StringBuilder builder = new StringBuilder();
        if (query.getWhereClause() != null) {
            ToJqlStringVisitor jqlStringVisitor = new ToJqlStringVisitor(this);
            builder.append(jqlStringVisitor.toJqlString(query.getWhereClause()));
        }
        if (query.getOrderByClause() != null && !query.getOrderByClause().getSearchSorts().isEmpty()) {
            if (builder.length() != 0) {
                builder.append(" ");
            }
            builder.append("ORDER BY ");
            Iterator<SearchSort> sortIterator = query.getOrderByClause().getSearchSorts().iterator();
            while (sortIterator.hasNext()) {
                SearchSort sort = sortIterator.next();
                builder.append(this.encodeFieldName(sort.getField()));
                if (sort.getOrder() != null) {
                    builder.append(" ").append(sort.getOrder());
                }
                if (!sortIterator.hasNext()) continue;
                builder.append(", ");
            }
        }
        return builder.toString();
    }

    @Override
    public String generateJqlString(Clause clause) {
        ToJqlStringVisitor jqlStringVisitor = new ToJqlStringVisitor(this);
        return jqlStringVisitor.toJqlString(clause);
    }

    private static boolean isLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String decode(String string) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)string)) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int position = 0;
        while (position < string.length()) {
            char currentCharacter = string.charAt(position);
            ++position;
            if (currentCharacter == '\\') {
                if (position >= string.length()) {
                    throw new IllegalArgumentException("Unterminated escape sequence.");
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.length());
                    if (position > 1) {
                        stringBuilder.append(string.substring(0, position - 1));
                    }
                }
                char escapeCharacter = string.charAt(position);
                ++position;
                Character substituteChar = STRING_DECODE_MAPPING.get(Character.valueOf(escapeCharacter));
                if (substituteChar == null) {
                    if (escapeCharacter == 'u') {
                        if (position + 4 > string.length()) {
                            throw new IllegalArgumentException("Unterminated escape sequence '\\u" + string.substring(position) + "'.");
                        }
                        String hexString = string.substring(position, position + 4);
                        position += 4;
                        try {
                            int i = Integer.parseInt(hexString, 16);
                            if (i < 0) {
                                throw new IllegalArgumentException("Illegal unicode escape '\\u" + hexString + "'.");
                            }
                            stringBuilder.append((char)i);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Illegal unicode escape '\\u" + hexString + "'.", e);
                        }
                    }
                    throw new IllegalArgumentException("Illegal escape sequence '\\" + escapeCharacter + "'.");
                }
                stringBuilder.append(substituteChar);
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(currentCharacter);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    public static String encodeAsQuotedString(String string) {
        return JqlStringSupportImpl.encodeAsQuotedString(string, false);
    }

    public static String encodeAsQuotedString(String string, boolean escapeNewline) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = null;
        for (int position = 0; position < string.length(); ++position) {
            char currentCharacter = string.charAt(position);
            String appendString = escapeNewline || currentCharacter != '\r' && currentCharacter != '\n' ? JqlStringSupportImpl.encodeCharacter(currentCharacter, 39, false) : null;
            if (appendString != null) {
                if (builder == null) {
                    builder = new StringBuilder(string.length());
                    builder.append('\"');
                    if (position > 0) {
                        builder.append(string.substring(0, position));
                    }
                }
                builder.append(appendString);
                continue;
            }
            if (builder == null) continue;
            builder.append(currentCharacter);
        }
        return builder == null ? '\"' + string + '\"' : builder.append('\"').toString();
    }

    private static String encodeCharacter(char character, int ignoredCharacter, boolean force) {
        if (ignoredCharacter >= 0 && character == (char)ignoredCharacter) {
            return null;
        }
        String encodedCharacter = STRING_ENCODE_MAPPING.get(Character.valueOf(character));
        if (encodedCharacter == null && (force || JqlStringSupportImpl.isJqlControl(character))) {
            return String.format("\\u%04x", character);
        }
        return encodedCharacter;
    }

    public static String encodeCharacterForce(char character) {
        return JqlStringSupportImpl.encodeCharacter(character, -1, true);
    }

    public static String encodeCharacter(char character) {
        return JqlStringSupportImpl.encodeCharacter(character, -1, false);
    }

    public static boolean isReservedString(String string) {
        Assertions.notNull("string", string);
        return RESERVED_WORDS.contains(string.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isJqlControl(char c) {
        return c >= '\u0000' && c <= '\t' || c >= '\u000b' && c <= '\f' || c >= '\u000e' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\ufdd0' && c <= '\ufdef' || c >= '\ufffe' && c <= '\uffff';
    }

    static {
        HashMap<Character, Character> decoderMapping = new HashMap<Character, Character>();
        decoderMapping.put(Character.valueOf('t'), Character.valueOf('\t'));
        decoderMapping.put(Character.valueOf('n'), Character.valueOf('\n'));
        decoderMapping.put(Character.valueOf('r'), Character.valueOf('\r'));
        decoderMapping.put(Character.valueOf('\\'), Character.valueOf('\\'));
        decoderMapping.put(Character.valueOf('\"'), Character.valueOf('\"'));
        decoderMapping.put(Character.valueOf('\''), Character.valueOf('\''));
        decoderMapping.put(Character.valueOf(' '), Character.valueOf(' '));
        STRING_DECODE_MAPPING = Collections.unmodifiableMap(decoderMapping);
        HashMap<Character, String> encoderStringMapping = new HashMap<Character, String>();
        encoderStringMapping.put(Character.valueOf('\t'), "\\t");
        encoderStringMapping.put(Character.valueOf('\n'), "\\n");
        encoderStringMapping.put(Character.valueOf('\r'), "\\r");
        encoderStringMapping.put(Character.valueOf('\"'), "\\\"");
        encoderStringMapping.put(Character.valueOf('\''), "\\'");
        encoderStringMapping.put(Character.valueOf('\\'), "\\\\");
        STRING_ENCODE_MAPPING = Collections.unmodifiableMap(encoderStringMapping);
        CollectionBuilder builder = CollectionBuilder.newBuilder();
        builder.addAll("abort", "access", "add", "after", "alias", "all", "alter", "and", "any", "as", "asc");
        builder.addAll("audit", "avg", "before", "begin", "between", "boolean", "break", "by", "byte", "catch", "cf", "changed");
        builder.addAll("char", "character", "check", "checkpoint", "collate", "collation", "column", "commit", "connect", "continue");
        builder.addAll("count", "create", "current", "date", "decimal", "declare", "decrement", "default", "defaults", "define", "delete");
        builder.addAll("delimiter", "desc", "difference", "distinct", "divide", "do", "double", "drop", "else", "empty", "encoding");
        builder.addAll("end", "equals", "escape", "exclusive", "exec", "execute", "exists", "explain", "false", "fetch", "file", "field");
        builder.addAll("first", "float", "for", "from", "function", "go", "goto", "grant", "greater", "group", "having");
        builder.addAll("identified", "if", "immediate", "in", "increment", "index", "initial", "inner", "inout", "input", "insert");
        builder.addAll("int", "integer", "intersect", "intersection", "into", "is", "isempty", "isnull", "join", "last", "left");
        builder.addAll("less", "like", "limit", "lock", "long", "max", "min", "minus", "mode", "modify");
        builder.addAll("modulo", "more", "multiply", "next", "noaudit", "not", "notin", "nowait", "null", "number", "object");
        builder.addAll("of", "on", "option", "or", "order", "outer", "output", "power", "previous", "prior", "privileges");
        builder.addAll("public", "raise", "raw", "remainder", "rename", "resource", "return", "returns", "revoke", "right", "row");
        builder.addAll("rowid", "rownum", "rows", "select", "session", "set", "share", "size", "sqrt", "start", "strict");
        builder.addAll("string", "subtract", "sum", "synonym", "table", "then", "to", "trans", "transaction", "trigger", "true");
        builder.addAll("uid", "union", "unique", "update", "user", "validate", "values", "view", "was", "when", "whenever", "where");
        builder.addAll("while", "with");
        RESERVED_WORDS = builder.asSet();
    }
}

