/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class JqlIssueSupportImpl
implements JqlIssueSupport {
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;

    public JqlIssueSupportImpl(IssueManager issueManager, PermissionManager permissionManager) {
        this.issueManager = Assertions.notNull("issueManager", issueManager);
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
    }

    @Override
    public Issue getIssue(long id, User user) {
        return this.checkPermission(user, this.issueManager.getIssueObject(id));
    }

    @Override
    public Issue getIssue(long id) {
        return this.issueManager.getIssueObject(id);
    }

    @Override
    public List<Issue> getIssues(String issueKey, User user) {
        return this.getIssues(issueKey, user, false);
    }

    @Override
    public List<Issue> getIssues(String issueKey) {
        return this.getIssues(issueKey, null, true);
    }

    List<Issue> getIssues(String issueKey, User user, boolean skipPermissionCheck) {
        if (StringUtils.isBlank((String)issueKey)) {
            return Collections.emptyList();
        }
        HashMap<Long, MutableIssue> issueMap = new HashMap<Long, MutableIssue>();
        for (String key : JqlIssueSupportImpl.keySearchNames(issueKey)) {
            MutableIssue issue = this.issueManager.getIssueObject(key);
            if (issue == null || issueMap.containsKey(issue.getId()) || !skipPermissionCheck && !this.permissionManager.hasPermission(10, issue, user)) continue;
            issueMap.put(issue.getId(), issue);
        }
        return new ArrayList<Issue>(issueMap.values());
    }

    private Issue checkPermission(User user, Issue issue) {
        if (issue != null && this.permissionManager.hasPermission(10, issue, user)) {
            return issue;
        }
        return null;
    }

    private static Set<String> keySearchNames(String key) {
        String upper = key.toUpperCase(Locale.ENGLISH);
        String lower = key.toLowerCase(Locale.ENGLISH);
        String folded = CaseFolding.foldString(key, Locale.ENGLISH);
        HashSet<String> names = new HashSet<String>();
        names.add(key);
        names.add(upper);
        names.add(lower);
        names.add(folded);
        return names;
    }
}

