/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlDurationSupport;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.NumberTools;

@InjectableComponent
public class JqlDurationSupportImpl
implements JqlDurationSupport {
    private static final Logger log = Logger.getLogger(JqlDurationSupportImpl.class);

    @Override
    public boolean validate(String durationString, boolean allowNegatives) {
        try {
            String trimDuration = StringUtils.trimToNull((String)durationString);
            if (trimDuration != null) {
                Long value = this.parseDurationWithNegative(trimDuration);
                return allowNegatives || value >= 0L;
            }
        }
        catch (InvalidDurationException e) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String convertToIndexValue(QueryLiteral rawValue) {
        Assertions.notNull("rawValue", rawValue);
        if (rawValue.getLongValue() != null) {
            return this.convertToIndexValue(rawValue.getLongValue());
        }
        if (rawValue.getStringValue() != null) {
            return this.convertToIndexValue(rawValue.getStringValue());
        }
        return null;
    }

    public Long convertToDuration(Long durationInMinutes) {
        Assertions.notNull("durationInMinutes", durationInMinutes);
        return this.convertToDuration(durationInMinutes.toString());
    }

    public Long convertToDuration(String durationString) {
        Assertions.notNull("durationString", durationString);
        String trimDuration = StringUtils.trimToNull((String)durationString);
        if (trimDuration != null) {
            try {
                return this.parseDurationWithNegative(trimDuration);
            }
            catch (InvalidDurationException e) {
                log.debug((Object)("Specified duration was not valid: '" + durationString + "'."), (Throwable)e);
            }
            catch (NumberFormatException e) {
                log.debug((Object)("Specified duration was not valid: '" + durationString + "'."), (Throwable)e);
            }
        }
        return null;
    }

    protected String convertToIndexValue(Long durationInMinutes) {
        Long l = this.convertToDuration(durationInMinutes);
        if (l != null) {
            return NumberTools.longToString((long)l);
        }
        return null;
    }

    protected String convertToIndexValue(String durationString) {
        Long l;
        String trimDuration = StringUtils.trimToNull((String)durationString);
        if (trimDuration != null && (l = this.convertToDuration(trimDuration)) != null) {
            return NumberTools.longToString((long)l);
        }
        return null;
    }

    Long parseDurationWithNegative(String str) throws InvalidDurationException {
        return DateUtils.getDurationWithNegative((String)str);
    }
}

