/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@InjectableComponent
public class JqlCascadingSelectLiteralUtil {
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;

    public JqlCascadingSelectLiteralUtil(JqlSelectOptionsUtil jqlSelectOptionsUtil) {
        this.jqlSelectOptionsUtil = Assertions.notNull("jqlSelectOptionsUtil", jqlSelectOptionsUtil);
    }

    public List<QueryLiteral> createQueryLiteralsFromOptions(Operand sourceOperand, Collection<Option> positiveOptions, Collection<Option> negativeOptions) {
        ArrayList<QueryLiteral> result = new ArrayList<QueryLiteral>();
        for (Option option : positiveOptions) {
            result.add(new QueryLiteral(sourceOperand, option.getOptionId()));
        }
        for (Option option : negativeOptions) {
            result.add(new QueryLiteral(sourceOperand, -option.getOptionId().longValue()));
        }
        return result;
    }

    public void processPositiveNegativeOptionLiterals(List<QueryLiteral> inputLiterals, List<QueryLiteral> positiveLiterals, List<QueryLiteral> negativeLiterals) {
        for (QueryLiteral literal : inputLiterals) {
            if (!literal.isEmpty() && this.isNegativeLiteral(literal)) {
                negativeLiterals.add(new QueryLiteral(literal.getSourceOperand(), -literal.getLongValue().longValue()));
                continue;
            }
            positiveLiterals.add(literal);
        }
    }

    public boolean isNegativeLiteral(QueryLiteral literal) {
        Long actualOptionId;
        return literal.getLongValue() != null && literal.getLongValue() < 0L && this.jqlSelectOptionsUtil.getOptionById(actualOptionId = Long.valueOf(-literal.getLongValue().longValue())) != null;
    }
}

