/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class UserResolverImpl
implements UserResolver {
    private static final Logger log = Logger.getLogger(UserResolverImpl.class);
    private final UserPickerSearchService userPickerSearchService;

    public UserResolverImpl(UserPickerSearchService userPickerSearchService) {
        this.userPickerSearchService = Assertions.notNull("userPickerSearchService", userPickerSearchService);
    }

    @Override
    public List<String> getIdsFromName(String name) {
        Assertions.notNull("name", name);
        String user = this.getUserNameFromUserName(name);
        if (user == null) {
            return this.getUserNameFromFullNameOrEmail(name);
        }
        return Collections.singletonList(user);
    }

    @Override
    public boolean nameExists(String name) {
        Assertions.notNull("name", name);
        if (this.getUserNameFromUserName(name) != null) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Username '" + name + "' not found - searching as email or full name."));
        }
        return !this.getUserNameFromFullNameOrEmail(name).isEmpty();
    }

    @Override
    public boolean idExists(Long id) {
        Assertions.notNull("name", id);
        return this.getUserNameFromUserName(id.toString()) != null || !this.getUserNameFromFullNameOrEmail(id.toString()).isEmpty();
    }

    List<String> pickEmailOrFullNameMatches(String name, List<String> fullNameMatches, List<String> emailMatches) {
        if (!fullNameMatches.isEmpty() && emailMatches.isEmpty()) {
            return fullNameMatches;
        }
        if (!emailMatches.isEmpty() && fullNameMatches.isEmpty()) {
            return emailMatches;
        }
        if (this.isEmail(name)) {
            return emailMatches;
        }
        return fullNameMatches;
    }

    String getUserNameFromUserName(String name) {
        User user = UserUtils.getUser(name.toLowerCase());
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    List<String> getUserNameFromFullNameOrEmail(String name) {
        ArrayList<String> fullNameMatches = new ArrayList<String>();
        ArrayList<String> emailMatches = new ArrayList<String>();
        Collection<User> users = UserUtils.getAllUsers();
        for (User user : users) {
            if (user.getDisplayName() != null && user.getDisplayName().equalsIgnoreCase(name)) {
                fullNameMatches.add(user.getName());
            }
            if (user.getEmailAddress() == null || !user.getEmailAddress().equalsIgnoreCase(name)) continue;
            emailMatches.add(user.getName());
        }
        return this.pickEmailOrFullNameMatches(name, fullNameMatches, emailMatches);
    }

    private boolean isEmail(String name) {
        return TextUtils.verifyEmail((String)name);
    }

    @Override
    public User get(Long id) {
        return this.getUser(id.toString());
    }

    @Override
    public Collection<User> getAll() {
        return UserUtils.getAllUsers();
    }

    User getUser(String name) {
        return UserUtils.getUser(name.toLowerCase());
    }
}

