/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@InjectableComponent
public class ProjectResolver
implements NameResolver<Project> {
    private final ProjectManager projectManager;

    public ProjectResolver(ProjectManager projectManager) {
        this.projectManager = Assertions.notNull("projectManager", projectManager);
    }

    @Override
    public List<String> getIdsFromName(String name) {
        Assertions.notNull("name", name);
        Project project = this.projectManager.getProjectObjByKeyIgnoreCase(name);
        if (project == null) {
            project = this.projectManager.getProjectObjByName(name);
        }
        if (project != null) {
            return Collections.singletonList(project.getId().toString());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean nameExists(String name) {
        Assertions.notNull("name", name);
        Project project = this.projectManager.getProjectObjByKeyIgnoreCase(name);
        if (project == null) {
            project = this.projectManager.getProjectObjByName(name);
        }
        return project != null;
    }

    @Override
    public boolean idExists(Long id) {
        Assertions.notNull("id", id);
        Project project = this.projectManager.getProjectObj(id);
        return project != null;
    }

    @Override
    public Project get(Long id) {
        return this.projectManager.getProjectObj(id);
    }

    @Override
    public Collection<Project> getAll() {
        return this.projectManager.getProjectObjects();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectResolver that = (ProjectResolver)o;
        return this.projectManager.equals(that.projectManager);
    }

    public int hashCode() {
        return this.projectManager.hashCode();
    }
}

