/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.List;

public class ProjectIndexInfoResolver
implements IndexInfoResolver<Project> {
    private final NameResolver<Project> nameResolver;

    public ProjectIndexInfoResolver(NameResolver<Project> nameResolver) {
        this.nameResolver = Assertions.notNull("nameResolver", nameResolver);
    }

    @Override
    public List<String> getIndexedValues(String rawValue) {
        Project project;
        Long projId;
        Assertions.notNull("rawValue", rawValue);
        List<String> projects = this.nameResolver.getIdsFromName(rawValue);
        if (projects.isEmpty() && (projId = this.getValueAsLong(rawValue)) != null && (project = this.nameResolver.get(projId)) != null) {
            return Collections.singletonList(project.getId().toString());
        }
        return projects;
    }

    @Override
    public List<String> getIndexedValues(Long rawValue) {
        Assertions.notNull("rawValue", rawValue);
        Project project = this.nameResolver.get(rawValue);
        if (project == null) {
            return this.nameResolver.getIdsFromName(rawValue.toString());
        }
        return CollectionBuilder.newBuilder(project.getId().toString()).asList();
    }

    @Override
    public String getIndexedValue(Project project) {
        Assertions.notNull("project", project);
        return project.getId().toString();
    }

    private Long getValueAsLong(String value) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

